/*
 * Decompiled with CFR 0.152.
 */
package creeperfireworks.config;

import creeperfireworks.common.Translations;
import creeperfireworks.util.ColorHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.component.FireworkExplosion;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void init() {
        Client.decodedColors.clear();
        ((List)ConfigHandler.CLIENT.fireworksColors.get()).forEach(colorString -> Client.decodedColors.add(ColorHelper.decode(colorString).getRGB()));
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    private static String getTranslation(String key, String ... values) {
        return Translations.get(key, values);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Client {
        private static final String[] colorStrings = new String[]{"#3B511A", "#41CD34"};
        private static final List<String> colorsList = List.of("colors");
        private static final IntList decodedColors = new IntArrayList();
        private static final Predicate<Object> hexValidator = s -> s instanceof String && ((String)s).matches("#[a-zA-Z\\d]{6}");
        private static final List<String> shapes = Stream.of(FireworkExplosion.Shape.values()).map(Enum::name).toList();
        private final WhiteNoiseConfigSpec.IntValue fireworksChance;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> fireworksColors;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksFlicker;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksTrail;
        private final WhiteNoiseConfigSpec.EnumValue<FireworkExplosion.Shape> fireworksShape;
        private final WhiteNoiseConfigSpec.IntValue fireworksHeight;

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("visuals");
            this.fireworksChance = builder.comment(ConfigHandler.getTranslation("fireworkschance")).defineInRange("fireworksChance", 100, 0, 100);
            this.fireworksColors = builder.comment(new String[]{ConfigHandler.getTranslation("colors"), "Default: [\"" + String.join((CharSequence)"\", \"", colorStrings) + "\"]"}).defineListAllowEmpty(colorsList, Client.getColors(), hexValidator);
            this.fireworksFlicker = builder.comment(ConfigHandler.getTranslation("fireworksflicker")).define("fireworksFlicker", true);
            this.fireworksTrail = builder.comment(ConfigHandler.getTranslation("fireworkstrail")).define("fireworksTrail", true);
            this.fireworksShape = builder.comment(new String[]{ConfigHandler.getTranslation("fireworksshape"), "One of: " + String.valueOf(shapes)}).defineEnum("fireworksShape", (Enum)FireworkExplosion.Shape.CREEPER);
            this.fireworksHeight = builder.comment(new String[]{ConfigHandler.getTranslation("fireworksheight"), "Default 5"}).defineInRange("fireworksHeight", 5, 0, 32);
        }

        public static int fireworksChance() {
            return (Integer)ConfigHandler.CLIENT.fireworksChance.get();
        }

        public static IntList getColorsList() {
            return decodedColors;
        }

        public static boolean fireworksFlicker() {
            return (Boolean)ConfigHandler.CLIENT.fireworksFlicker.get();
        }

        public static boolean fireworksTrail() {
            return (Boolean)ConfigHandler.CLIENT.fireworksTrail.get();
        }

        public static FireworkExplosion.Shape getFireworksShape() {
            return (FireworkExplosion.Shape)ConfigHandler.CLIENT.fireworksShape.get();
        }

        public static float getFireworksHeight() {
            return ((Integer)ConfigHandler.CLIENT.fireworksHeight.get()).intValue();
        }

        private static Supplier<List<? extends String>> getColors() {
            return () -> Arrays.asList(colorStrings);
        }
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue disableBlockDamage;
        private final WhiteNoiseConfigSpec.BooleanValue disableItemDamage;

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("general");
            this.disableBlockDamage = builder.comment(ConfigHandler.getTranslation("disableblockdamage")).define("disableBlockDamage", true);
            this.disableItemDamage = builder.comment(ConfigHandler.getTranslation("disableitemdamage")).define("disableItemDamage", true);
        }

        public static boolean disableBlockDamage() {
            return (Boolean)ConfigHandler.COMMON.disableBlockDamage.get();
        }

        public static boolean disableItemDamage() {
            return (Boolean)ConfigHandler.COMMON.disableItemDamage.get();
        }
    }
}

