/*
 * Decompiled with CFR 0.152.
 */
package creeperfireworks.config;

import creeperfireworks.util.ColorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1781;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void init() {
        Client.decodedColors.clear();
        ((List)ConfigHandler.CLIENT.fireworksColors.get()).forEach(colorString -> Client.decodedColors.add(ColorHelper.decode(colorString).getRGB()));
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Client {
        private static final String[] colorStrings = new String[]{"#3B511A", "#41CD34"};
        private static final List<String> colorsList = List.of("colors");
        private static final List<Integer> decodedColors = new ArrayList<Integer>();
        private static final Predicate<Object> hexValidator = s -> s instanceof String && ((String)s).matches("#[a-zA-Z\\d]{6}");
        private static final List<String> shapes = Stream.of(class_1781.class_1782.values()).map(Enum::name).toList();
        private final WhiteNoiseConfigSpec.IntValue fireworksChance;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> fireworksColors;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksFlicker;
        private final WhiteNoiseConfigSpec.ConfigValue<String> fireworksShape;
        private final WhiteNoiseConfigSpec.IntValue fireworksHeight;

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("visuals");
            this.fireworksChance = builder.comment("Chance of fireworks after creeper explosion.").defineInRange("fireworksChance", 100, 0, 100);
            this.fireworksColors = builder.comment("Colors to use in fireworks. Requires hex color. Default: [\"" + String.join((CharSequence)"\", \"", colorStrings) + "\"]").defineListAllowEmpty(colorsList, Client.getColors(), hexValidator);
            this.fireworksFlicker = builder.comment("Fireworks flicker.").define("fireworksFlicker", true);
            this.fireworksShape = builder.comment("Fireworks shape. One of: " + String.valueOf(shapes)).defineInList("fireworksShape", (Object)"CREEPER", shapes);
            this.fireworksHeight = builder.comment("Height above creeper that fireworks explode. Default 5").defineInRange("fireworksHeight", 5, 0, 32);
        }

        public static int fireworksChance() {
            return (Integer)ConfigHandler.CLIENT.fireworksChance.get();
        }

        public static List<Integer> getColorsList() {
            return decodedColors;
        }

        public static boolean fireworksFlicker() {
            return (Boolean)ConfigHandler.CLIENT.fireworksFlicker.get();
        }

        public static int getFireworksShape() {
            return class_1781.class_1782.valueOf((String)((String)ConfigHandler.CLIENT.fireworksShape.get())).method_7816();
        }

        public static float getFireworksHeight() {
            return ((Integer)ConfigHandler.CLIENT.fireworksHeight.get()).intValue();
        }

        private static Supplier<List<? extends String>> getColors() {
            return () -> Arrays.asList(colorStrings);
        }
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue disableBlockDamage;
        private final WhiteNoiseConfigSpec.BooleanValue disableItemDamage;

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("general");
            this.disableBlockDamage = builder.comment("Disable block damage on Creeper explosion.").define("disableBlockDamage", true);
            this.disableItemDamage = builder.comment("Disable dropped item damage on Creeper explosion.").define("disableItemDamage", true);
        }

        public static boolean disableBlockDamage() {
            return (Boolean)ConfigHandler.COMMON.disableBlockDamage.get();
        }

        public static boolean disableItemDamage() {
            return (Boolean)ConfigHandler.COMMON.disableItemDamage.get();
        }
    }
}

