/*
 * Decompiled with CFR 0.152.
 */
package creeperfireworks.mixin;

import creeperfireworks.config.ConfigHandler;
import creeperfireworks.platform.Services;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class MixinLevel {
    @Shadow
    @Final
    private static WeightedList<ExplosionParticleInfo> DEFAULT_EXPLOSION_BLOCK_PARTICLES;

    @Inject(method={"explode(Lnet/minecraft/world/entity/Entity;DDDFLnet/minecraft/world/level/Level$ExplosionInteraction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cf$explode(Entity entity, double x, double y, double z, float radius, Level.ExplosionInteraction explosionInteraction, CallbackInfo ci) {
        if (entity instanceof Creeper) {
            ServerLevel serverLevel;
            Creeper creeper = (Creeper)entity;
            this.creeperFireworks$boom(creeper);
            Level level = (Level)this;
            if (level.getServer() != null && (serverLevel = level.getServer().getLevel(level.dimension())) != null && serverLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && ConfigHandler.Common.disableBlockDamage()) {
                level.explode(entity, Explosion.getDefaultDamageSource((Level)level, (Entity)entity), null, x, y, z, radius, false, Level.ExplosionInteraction.NONE, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, (Holder)SoundEvents.GENERIC_EXPLODE);
                ci.cancel();
            }
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true)
    private void cf$getEntities(Entity enitity, AABB $$1, Predicate<? super Entity> $$2, CallbackInfoReturnable<List<Entity>> cir) {
        if (enitity instanceof Creeper) {
            cir.setReturnValue(this.creeperFireworks$getEntities((List)cir.getReturnValue()));
        }
    }

    @Unique
    private <T extends Entity> List<T> creeperFireworks$getEntities(List<T> entities) {
        if (ConfigHandler.Common.disableItemDamage()) {
            entities.removeIf(e -> e instanceof ItemEntity);
        }
        return entities;
    }

    @Unique
    private void creeperFireworks$boom(Creeper creeper) {
        Services.PLATFORM.sendLaunchFireworksPacket(creeper);
    }
}

