/*
 * Decompiled with CFR 0.152.
 */
package com.bizcub.simpleDatapacks.mixin;

import com.bizcub.simpleDatapacks.SimpleDatapacks;
import com.bizcub.simpleDatapacks.config.Compat;
import com.bizcub.simpleDatapacks.config.Configs;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess storageSource;
    @Shadow
    @Final
    private PackRepository packRepository;

    @Shadow
    public abstract CompletableFuture<Void> reloadResources(Collection<String> var1);

    @Inject(method={"<init>(Ljava/lang/Thread;Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Ljava/net/Proxy;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/server/Services;Lnet/minecraft/server/level/progress/ChunkProgressListenerFactory;)V"}, at={@At(value="TAIL")})
    public void reload(CallbackInfo ci) {
        this.reloadResources(this.packRepository.getSelectedIds());
    }

    @Inject(method={"reloadResources(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    private void copyDatapacksInGame(CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        if (this.packRepository != null) {
            Path path = this.storageSource.getLevelPath(LevelResource.DATAPACK_DIR);
            Collection enabled = this.packRepository.getSelectedIds();
            SimpleDatapacks.copyDatapacks(path, new ArrayList<String>(enabled));
        }
    }

    @Redirect(method={"configurePackRepository(Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/world/level/WorldDataConfiguration;ZZ)Lnet/minecraft/world/level/WorldDataConfiguration;"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", ordinal=1))
    private static boolean preventAutoLoading(Set<String> packs, Object pack) {
        String packName = (String)pack;
        if (Compat.isModLoaded("cloth_config") && Configs.getInstance().globalDatapacks || !packName.startsWith("file/")) {
            return packs.add(packName);
        }
        return false;
    }
}

