/*
 * Decompiled with CFR 0.152.
 */
package com.bizcub.simpleDatapacks;

import com.bizcub.simpleDatapacks.config.Compat;
import com.bizcub.simpleDatapacks.config.Configs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SimpleDatapacks {
    public static final String modId = "simple_datapacks";
    public static final String clothConfigId = "cloth_config";
    public static Path minecraftFolder;

    public static void init(Path path) throws SecurityException {
        path.toFile().mkdirs();
        minecraftFolder = path;
        if (Compat.isModLoaded(clothConfigId)) {
            Configs.init();
        }
    }

    public static void copyDatapacks(Path dest, List<String> rawDatapacks) {
        if (Compat.isModLoaded(clothConfigId)) {
            if (!Configs.getInstance().copyDatapacks) {
                return;
            }
        } else {
            return;
        }
        for (String path : Configs.getInstance().datapacksPaths) {
            Path src = Paths.get(path, new String[0]);
            ArrayList datapacks = new ArrayList();
            rawDatapacks.removeIf(str -> !str.startsWith("file/"));
            rawDatapacks.forEach(s -> datapacks.add(s.substring(5)));
            String[] copiedDatapacks = dest.toFile().list();
            if (copiedDatapacks != null) {
                datapacks.removeAll(Arrays.asList(copiedDatapacks));
            }
            try {
                for (String str2 : datapacks) {
                    if (!Files.exists(src.resolve(str2), new LinkOption[0])) continue;
                    Path pack = src.resolve(str2);
                    if (Files.isRegularFile(pack, new LinkOption[0]) && pack.toString().endsWith(".zip")) {
                        FileUtils.copyFile((File)pack.toFile(), (File)dest.resolve(str2).toFile());
                        continue;
                    }
                    FileUtils.copyDirectory((File)pack.toFile(), (File)dest.resolve(str2).toFile());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

