/*
 * Decompiled with CFR 0.152.
 */
package com.awakenedredstone.defaultcomponents.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentWeakSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final ConcurrentHashMap<WeakReference<E>, Boolean> map;

    public ConcurrentWeakSet() {
        this.map = new ConcurrentHashMap();
    }

    public ConcurrentWeakSet(int capacity) {
        this.map = new ConcurrentHashMap(capacity);
    }

    public ConcurrentWeakSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            throw new NullPointerException("Null elements are not allowed");
        }
        this.removeStaleReferences();
        WeakReference<E> weakRef = new WeakReference<E>(element);
        return this.map.put(weakRef, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        this.removeStaleReferences();
        for (WeakReference ref : this.map.keySet()) {
            Object element = ref.get();
            if (element == null || !object.equals(element)) continue;
            return this.map.remove(ref) != null;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        this.removeStaleReferences();
        for (WeakReference ref : this.map.keySet()) {
            Object element = ref.get();
            if (element == null || !object.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        this.removeStaleReferences();
        return new Iterator<E>(){
            private final Iterator<WeakReference<E>> iterator;
            private E nextElement;
            private boolean hasNextCalled;
            {
                this.iterator = ((ConcurrentHashMap.KeySetView)ConcurrentWeakSet.this.map.keySet()).iterator();
                this.nextElement = null;
                this.hasNextCalled = false;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextCalled) {
                    return this.nextElement != null;
                }
                while (this.iterator.hasNext()) {
                    WeakReference ref = this.iterator.next();
                    this.nextElement = ref.get();
                    if (this.nextElement != null) {
                        this.hasNextCalled = true;
                        return true;
                    }
                    this.iterator.remove();
                }
                this.hasNextCalled = true;
                return false;
            }

            @Override
            public E next() {
                if (!this.hasNextCalled) {
                    this.hasNext();
                }
                this.hasNextCalled = false;
                return this.nextElement;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        this.removeStaleReferences();
        return this.map.size();
    }

    private void removeStaleReferences() {
        this.map.keySet().removeIf(ref -> ref.get() == null);
    }
}

