/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.containers.grids;

import com.diamssword.greenresurgence.containers.grids.ContainerArmorGrid;
import com.diamssword.greenresurgence.containers.grids.GridContainer;
import com.diamssword.greenresurgence.containers.grids.IGridContainer;
import com.diamssword.greenresurgence.containers.player.grids.ArmorGrid;
import com.diamssword.greenresurgence.containers.player.grids.BagsGrid;
import com.diamssword.greenresurgence.containers.player.grids.OffHandGrid;
import com.diamssword.greenresurgence.containers.player.grids.PlayerGrid;
import com.diamssword.greenresurgence.utils.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class GridContainerSyncer {
    private static final Map<String, TriFunction<String, Integer, Integer, IGridContainer>> factories = new HashMap<String, TriFunction<String, Integer, Integer, IGridContainer>>();
    private static final Map<Class<? extends IGridContainer>, String> serializers = new HashMap<Class<? extends IGridContainer>, String>();
    public int count;
    public String[] names;
    public String[] serializingId;
    public int[] sizes;
    public class_2338 inventoryPos;

    private static void registerGridSerializer(Class<? extends IGridContainer> clazz, String id, TriFunction<String, Integer, Integer, IGridContainer> factory) {
        serializers.put(clazz, id);
        factories.put(id, factory);
    }

    public GridContainerSyncer(@Nullable class_2338 inventoryPos, IGridContainer ... containers) {
        this.inventoryPos = inventoryPos;
        this.count = containers.length;
        ArrayList<Integer> ls = new ArrayList<Integer>();
        ArrayList<String> ls1 = new ArrayList<String>();
        ArrayList<String> ls2 = new ArrayList<String>();
        for (IGridContainer container : containers) {
            ls1.add(container.getName());
            ls2.add(serializers.getOrDefault(container.getClass(), "basic"));
            ls.add(container.getWidth());
            ls.add(container.getHeight());
        }
        this.names = ls1.toArray(new String[0]);
        this.serializingId = ls2.toArray(new String[0]);
        this.sizes = new int[ls.size()];
        for (int i = 0; i < ls.size(); ++i) {
            this.sizes[i] = (Integer)ls.get(i);
        }
    }

    public GridContainerSyncer() {
        this.count = 0;
        this.names = new String[0];
        this.serializingId = new String[0];
        this.sizes = new int[0];
    }

    public IGridContainer[] getContainers() {
        IGridContainer[] res = new IGridContainer[this.count];
        for (int i = 0; i < this.count; ++i) {
            TriFunction<String, Integer, Integer, IGridContainer> fac = factories.get(this.serializingId[i]);
            res[i] = fac != null ? fac.accept(this.names[i], this.sizes[i * 2], this.sizes[i * 2 + 1]) : new GridContainer(this.names[i], this.sizes[i * 2], this.sizes[i * 2 + 1]);
        }
        return res;
    }

    public static void serializer(class_2540 write, GridContainerSyncer val) {
        if (val.inventoryPos == null) {
            val.inventoryPos = class_2338.field_10980;
        }
        write.writeInt(val.count);
        write.method_10807(val.inventoryPos);
        write.method_10806(val.sizes);
        for (String name : val.names) {
            write.method_10814(name);
        }
        for (String serial : val.serializingId) {
            write.method_10814(serial);
        }
    }

    public static GridContainerSyncer unserializer(class_2540 read) {
        int i;
        GridContainerSyncer p = new GridContainerSyncer();
        p.count = read.readInt();
        p.inventoryPos = read.method_10811();
        p.sizes = read.method_10787();
        p.names = new String[p.count];
        for (i = 0; i < p.count; ++i) {
            p.names[i] = read.method_19772();
        }
        p.serializingId = new String[p.count];
        for (i = 0; i < p.count; ++i) {
            p.serializingId[i] = read.method_19772();
        }
        return p;
    }

    static {
        GridContainerSyncer.registerGridSerializer(GridContainer.class, "basic", GridContainer::new);
        GridContainerSyncer.registerGridSerializer(PlayerGrid.class, "player", PlayerGrid::new);
        GridContainerSyncer.registerGridSerializer(ArmorGrid.class, "playerArmor", ArmorGrid::new);
        GridContainerSyncer.registerGridSerializer(OffHandGrid.class, "playerOffhand", OffHandGrid::new);
        GridContainerSyncer.registerGridSerializer(BagsGrid.class, "bagSlots", BagsGrid::new);
        GridContainerSyncer.registerGridSerializer(ContainerArmorGrid.class, "containerArmor", ContainerArmorGrid::new);
    }
}

