/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.entities;

import com.diamssword.greenresurgence.MItems;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.EntitiesPackets;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2553;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_5459;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TwoPassengerVehicle
extends class_1297
implements GeoEntity {
    private static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(TwoPassengerVehicle.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> CONTROLLER_POS = class_2945.method_12791(TwoPassengerVehicle.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(TwoPassengerVehicle.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(TwoPassengerVehicle.class, (class_2941)class_2943.field_13320);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float velocityDecay;
    private float ticksUnderwater;
    private float yawVelocity;
    private double lastSpeed;
    private double lastHeight;
    private double heightSpeedCap;
    private int field_7708;
    private double x;
    private double y;
    private double z;
    private double boatYaw;
    private double boatPitch;
    private boolean pressingLeft;
    private boolean pressingRight;
    private boolean pressingForward;
    private boolean pressingBack;
    private double waterLevel;
    private float nearbySlipperiness;
    private class_1690.class_1691 location;
    private class_1690.class_1691 lastLocation;
    private double fallVelocity;

    public TwoPassengerVehicle(class_1299<? extends TwoPassengerVehicle> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
        this.method_49477(0.5f);
    }

    public TwoPassengerVehicle(class_1299<? extends TwoPassengerVehicle> entityType, class_1937 world, double x, double y, double z) {
        this(entityType, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.field_6011.method_12784(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.field_6011.method_12784(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(CONTROLLER_POS, (Object)1);
    }

    public boolean method_30949(class_1297 other) {
        return TwoPassengerVehicle.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_30633(class_2350.class_2351 portalAxis, class_5459.class_5460 portalRect) {
        return class_1309.method_31079((class_243)super.method_30633(portalAxis, portalRect));
    }

    public double method_5621() {
        return 0.4;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            boolean bl;
            this.setDamageWobbleSide(-this.getDamageWobbleSide());
            this.setDamageWobbleTicks(10);
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
            this.method_5785();
            this.method_32875(class_5712.field_28736, source.method_5529());
            boolean bl2 = bl = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
            if (bl || this.getDamageWobbleStrength() > 40.0f) {
                if (!bl && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                    this.dropItems(source);
                }
                this.method_31472();
            }
            return true;
        }
        return true;
    }

    protected void dropItems(class_1282 source) {
        this.method_5706((class_1935)this.asItem());
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof class_1690) {
            if (entity.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entity);
            }
        } else if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public class_1792 asItem() {
        return MItems.CADDIE;
    }

    public void method_5879(float yaw) {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_7708 = 10;
    }

    public class_2350 method_5755() {
        return this.method_5735().method_10170();
    }

    public void method_5773() {
        this.lastLocation = this.location;
        this.location = this.checkLocation();
        this.ticksUnderwater = this.location != class_1690.class_1691.field_7717 && this.location != class_1690.class_1691.field_7716 ? 0.0f : (this.ticksUnderwater += 1.0f);
        if (!this.method_37908().field_9236) {
            Integer d = (Integer)this.field_6011.method_12789(CONTROLLER_POS);
            if (!this.method_5782()) {
                this.field_6011.method_12778(CONTROLLER_POS, (Object)1);
            }
            if (d < this.method_5685().size()) {
                class_1657 pl;
                PlayerData comp;
                ent = (class_1297)this.method_5685().get(d);
                if (ent instanceof class_1657 && !"pushing_cart".equals((comp = (PlayerData)(pl = (class_1657)ent).getComponent(Components.PLAYER_DATA)).getCustomPoseID())) {
                    comp.setCustomPose("pushing_cart");
                }
            } else {
                class_1657 pl;
                PlayerData comp;
                ent = this.method_31483();
                if (ent instanceof class_1657 && "pushing_cart".equals((comp = (PlayerData)(pl = (class_1657)ent).getComponent(Components.PLAYER_DATA)).getCustomPoseID())) {
                    comp.setCustomPose(null);
                }
            }
        }
        if (!this.method_37908().field_9236 && this.ticksUnderwater >= 60.0f) {
            this.method_5772();
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        this.updatePositionAndRotation();
        if (this.method_5787()) {
            class_243 velocity = this.method_18798();
            float yawRad = (float)Math.toRadians(-this.method_36454());
            class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
            double curr = velocity.method_1026(forward);
            if (this.lastSpeed > 0.6 && curr < (double)0.01f && this.method_37908().field_9236) {
                Channels.MAIN.clientHandle().send((Record)new EntitiesPackets.OnWallCollided(this.lastSpeed));
            }
            this.lastSpeed = curr;
            double hei = this.method_19538().field_1351;
            this.heightSpeedCap = hei < this.lastHeight ? (this.heightSpeedCap += 0.2) : Math.max(0.0, this.heightSpeedCap - (double)0.1f);
            this.lastHeight = hei;
            this.updateVelocity();
            if (this.method_37908().field_9236) {
                this.updatePaddles();
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.method_5852();
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            for (class_1297 value : list) {
                if (value.method_5626((class_1297)this)) continue;
                this.method_5697(value);
            }
        }
    }

    private void updatePositionAndRotation() {
        if (this.method_5787()) {
            this.field_7708 = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.field_7708 > 0) {
            double d = this.method_23317() + (this.x - this.method_23317()) / (double)this.field_7708;
            double e = this.method_23318() + (this.y - this.method_23318()) / (double)this.field_7708;
            double f = this.method_23321() + (this.z - this.method_23321()) / (double)this.field_7708;
            double g = class_3532.method_15338((double)(this.boatYaw - (double)this.method_36454()));
            this.method_36456(this.method_36454() + (float)g / (float)this.field_7708);
            this.method_36457(this.method_36455() + (float)(this.boatPitch - (double)this.method_36455()) / (float)this.field_7708);
            --this.field_7708;
            this.method_5814(d, e, f);
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    private class_1690.class_1691 checkLocation() {
        class_1690.class_1691 location = this.getUnderWaterLocation();
        if (location != null) {
            this.waterLevel = this.method_5829().field_1325;
            return location;
        }
        if (this.checkBoatInWater()) {
            return class_1690.class_1691.field_7718;
        }
        float f = this.getNearbySlipperiness();
        if (f > 0.0f) {
            this.nearbySlipperiness = f;
            return class_1690.class_1691.field_7719;
        }
        return class_1690.class_1691.field_7720;
    }

    public float getWaterHeightBelow() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)(box.field_1325 - this.fallVelocity));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        block0: for (int o = k; o < l; ++o) {
            float f = 0.0f;
            for (int p = i; p < j; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(p, o, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (fluidState.method_15767(class_3486.field_15517)) {
                        f = Math.max(f, fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)mutable.method_10264() + f;
        }
        return l + 1;
    }

    public float getNearbySlipperiness() {
        class_238 box = this.method_5829();
        class_238 box2 = new class_238(box.field_1323, box.field_1322 - 0.001, box.field_1321, box.field_1320, box.field_1322, box.field_1324);
        int i = class_3532.method_15357((double)box2.field_1323) - 1;
        int j = class_3532.method_15384((double)box2.field_1320) + 1;
        int k = class_3532.method_15357((double)box2.field_1322) - 1;
        int l = class_3532.method_15384((double)box2.field_1325) + 1;
        int m = class_3532.method_15357((double)box2.field_1321) - 1;
        int n = class_3532.method_15384((double)box2.field_1324) + 1;
        class_265 voxelShape = class_259.method_1078((class_238)box2);
        float f = 0.0f;
        int o = 0;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutable.method_10103(p, s, q);
                    class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                    if (blockState.method_26204() instanceof class_2553 || !class_259.method_1074((class_265)blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutable).method_1096((double)p, (double)s, (double)q), (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
                    f += blockState.method_26204().method_9499();
                    ++o;
                }
            }
        }
        return f / (float)o;
    }

    private boolean checkBoatInWater() {
        class_238 box = this.method_5829();
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1322);
        int l = class_3532.method_15384((double)(box.field_1322 + 0.001));
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        this.waterLevel = -1.7976931348623157E308;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(class_3486.field_15517)) continue;
                    float f = (float)p + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= box.field_1322 < (double)f;
                }
            }
        }
        return bl;
    }

    @Nullable
    private class_1690.class_1691 getUnderWaterLocation() {
        class_238 box = this.method_5829();
        double d = box.field_1325 + 0.001;
        int i = class_3532.method_15357((double)box.field_1323);
        int j = class_3532.method_15384((double)box.field_1320);
        int k = class_3532.method_15357((double)box.field_1325);
        int l = class_3532.method_15384((double)d);
        int m = class_3532.method_15357((double)box.field_1321);
        int n = class_3532.method_15384((double)box.field_1324);
        boolean bl = false;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    mutable.method_10103(o, p, q);
                    class_3610 fluidState = this.method_37908().method_8316((class_2338)mutable);
                    if (!fluidState.method_15767(class_3486.field_15517) || !(d < (double)((float)mutable.method_10264() + fluidState.method_15763((class_1922)this.method_37908(), (class_2338)mutable)))) continue;
                    if (!fluidState.method_15771()) {
                        return class_1690.class_1691.field_7716;
                    }
                    bl = true;
                }
            }
        }
        return bl ? class_1690.class_1691.field_7717 : null;
    }

    private void updateVelocity() {
        double e = this.method_5740() ? 0.0 : (double)-0.04f;
        double f = 0.0;
        this.velocityDecay = 0.05f;
        if (this.lastLocation == class_1690.class_1691.field_7720 && this.location != class_1690.class_1691.field_7720 && this.location != class_1690.class_1691.field_7719) {
            this.waterLevel = this.method_23323(1.0);
            this.method_5814(this.method_23317(), (double)(this.getWaterHeightBelow() - this.method_17682()) + 0.101, this.method_23321());
            this.method_18799(this.method_18798().method_18805(1.0, 0.0, 1.0));
            this.fallVelocity = 0.0;
            this.location = class_1690.class_1691.field_7718;
        } else {
            if (this.location == class_1690.class_1691.field_7718) {
                f = 0.01f;
                this.velocityDecay = 0.45f;
            } else if (this.location == class_1690.class_1691.field_7716) {
                e = -7.0E-4;
                this.velocityDecay = 0.9f;
            } else if (this.location == class_1690.class_1691.field_7717) {
                f = 0.01f;
                this.velocityDecay = 0.45f;
            } else if (this.location == class_1690.class_1691.field_7720) {
                this.velocityDecay = this.pressingForward ? 1.0f : Math.min(0.9f, this.nearbySlipperiness * 1.5f);
            } else if (this.location == class_1690.class_1691.field_7719) {
                float f2 = this.velocityDecay = this.pressingForward ? 1.0f : Math.min(0.9f, this.nearbySlipperiness * 1.5f);
                if (this.method_5642() instanceof class_1657) {
                    this.nearbySlipperiness /= 2.0f;
                }
            }
            class_243 vec3d = this.method_18798();
            double bound = 2.5 + Math.min(this.heightSpeedCap, 30.0);
            this.method_18800(class_3532.method_15350((double)(vec3d.field_1352 * (double)this.velocityDecay), (double)(-bound), (double)bound), vec3d.field_1351 + e, class_3532.method_15350((double)(vec3d.field_1350 * (double)this.velocityDecay), (double)(-bound), (double)bound));
            this.yawVelocity = this.yawVelocity * this.velocityDecay / 2.0f;
            if (f > 0.0) {
                class_243 vec3d2 = this.method_18798();
                this.method_18800(vec3d2.field_1352, (vec3d2.field_1351 + f * 0.06153846016296973) * 0.75, vec3d2.field_1350);
            }
        }
    }

    private void updatePaddles() {
        if (this.method_5782()) {
            float f = 0.0f;
            if (this.pressingLeft) {
                this.yawVelocity -= 1.0f;
            }
            if (this.pressingRight) {
                this.yawVelocity += 1.0f;
            }
            if (this.pressingRight != this.pressingLeft && !this.pressingForward && !this.pressingBack) {
                f += 0.005f;
            }
            this.method_36456(this.method_36454() + this.yawVelocity);
            if (this.pressingForward) {
                f += 0.005f;
            }
            if (this.pressingBack) {
                f -= 0.005f;
            }
            this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * f), 0.0, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * f)));
        }
    }

    protected float getPassengerHorizontalOffset() {
        return 0.0f;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        if (this.method_5626(passenger)) {
            float f = this.getPassengerHorizontalOffset();
            float g = (float)((this.method_31481() ? (double)0.01f : this.method_5621()) + passenger.method_5678());
            int i = this.method_5685().indexOf(passenger);
            if (i == (Integer)this.field_6011.method_12789(CONTROLLER_POS)) {
                f = -1.0f;
            }
            class_243 vec3d = new class_243((double)f, 0.0, 0.0).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
            positionUpdater.accept(passenger, this.method_23317() + vec3d.field_1352, this.method_23318() + (double)g, this.method_23321() + vec3d.field_1350);
            passenger.method_36456(passenger.method_36454() + this.yawVelocity);
            passenger.method_5847(passenger.method_5791() + this.yawVelocity);
            this.copyEntityData(passenger);
            if (passenger instanceof class_1429 && this.method_5685().size() == this.getMaxPassengers()) {
                int j = passenger.method_5628() % 2 == 0 ? 90 : 270;
                passenger.method_5636(((class_1429)passenger).field_6283 + (float)j);
                passenger.method_5847(passenger.method_5791() + (float)j);
            }
        }
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = TwoPassengerVehicle.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23321() + vec3d.field_1350;
        class_2338 blockPos = class_2338.method_49637((double)d, (double)this.method_5829().field_1325, (double)e);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.method_37908().method_22351(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.method_37908().method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos2)))) {
                list.add(new class_243(d, (double)blockPos2.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    protected void copyEntityData(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.copyEntityData(passenger);
    }

    protected void method_5652(class_2487 nbt) {
    }

    protected void method_5749(class_2487 nbt) {
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (this.ticksUnderwater < 60.0f) {
            if (!this.method_37908().field_9236) {
                float entityYaw = (float)Math.toRadians(-this.method_36454());
                double localZ = hitPos.field_1352 * Math.sin(entityYaw) + hitPos.field_1350 * Math.cos(entityYaw);
                if (player.method_5804((class_1297)this)) {
                    if (localZ < (double)-0.3f) {
                        Integer curr = (Integer)this.field_6011.method_12789(CONTROLLER_POS);
                        List ls = this.method_5685();
                        if (ls.size() < 2) {
                            this.field_6011.method_12778(CONTROLLER_POS, (Object)0);
                        } else if (curr != 0) {
                            this.field_6011.method_12778(CONTROLLER_POS, (Object)1);
                        }
                    }
                    return class_1269.field_21466;
                }
                return class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return super.method_5688(player, hand);
    }

    protected void method_5793(class_1297 passenger) {
        int ind = this.method_5685().indexOf(passenger);
        if (!passenger.method_37908().field_9236) {
            Integer cont = (Integer)this.field_6011.method_12789(CONTROLLER_POS);
            if (ind == 0) {
                if (cont == 1) {
                    this.field_6011.method_12778(CONTROLLER_POS, (Object)0);
                } else {
                    this.field_6011.method_12778(CONTROLLER_POS, (Object)1);
                }
            }
        }
        super.method_5793(passenger);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        this.fallVelocity = this.method_18798().field_1351;
        if (!this.method_5765()) {
            if (onGround) {
                if (this.field_6017 > 3.0f) {
                    this.method_5747(this.field_6017, 1.0f, this.method_48923().method_48827());
                    if (this.field_6017 > 15.0f && !this.method_37908().field_9236 && !this.method_31481()) {
                        this.method_5768();
                        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                            this.method_5706((class_1935)this.asItem());
                        }
                    }
                    if (this.location != class_1690.class_1691.field_7719) {
                        this.method_38785();
                    }
                }
                this.method_38785();
            } else if (!this.method_37908().method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517) && heightDifference < 0.0) {
                this.field_6017 -= (float)heightDifference;
            }
        }
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers() && !this.method_5777(class_3486.field_15517);
    }

    protected int getMaxPassengers() {
        return 2;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 livingEntity;
        Integer pos = (Integer)this.field_6011.method_12789(CONTROLLER_POS);
        if (pos == 0) {
            class_1309 livingEntity2;
            class_1297 class_12972 = this.method_31483();
            return class_12972 instanceof class_1309 ? (livingEntity2 = (class_1309)class_12972) : null;
        }
        class_1297 class_12973 = this.getSecondPassenger();
        return class_12973 instanceof class_1309 ? (livingEntity = (class_1309)class_12973) : null;
    }

    @Nullable
    public class_1297 getSecondPassenger() {
        return this.method_5685().size() < 2 ? null : (class_1297)this.method_5685().get(1);
    }

    public void setInputs(boolean pressingLeft, boolean pressingRight, boolean pressingForward, boolean pressingBack) {
        this.pressingLeft = pressingLeft;
        this.pressingRight = pressingRight;
        this.pressingForward = pressingForward;
        this.pressingBack = pressingBack;
    }

    public boolean method_5869() {
        return this.location == class_1690.class_1691.field_7717 || this.location == class_1690.class_1691.field_7716;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.asItem());
    }

    public boolean isMoving() {
        return this.method_18798().method_1033() > (double)0.1f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, state -> {
            if (this.isMoving()) {
                return state.setAndContinue(DefaultAnimations.DRIVE);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

