/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui;

import com.diamssword.characters.api.CharactersApi;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.api.stats.IPlayerStats;
import com.diamssword.characters.api.stats.StatsRole;
import com.diamssword.characters.api.stats.StatsRolePalier;
import com.diamssword.greenresurgence.DrawUtils;
import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.components.ClickableLayoutComponent;
import com.diamssword.greenresurgence.gui.components.FreeRowGridLayout;
import com.diamssword.greenresurgence.gui.components.PlayerComponent;
import com.diamssword.greenresurgence.gui.components.hud.BarComponent;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.StatsPackets;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import com.diamssword.greenresurgence.systems.character.PlayerInventoryData;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PlayerStatsGui
extends BaseUIModelScreen<FlowLayout> {
    private FreeRowGridLayout statsPanel;

    public PlayerStatsGui() {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)GreenResurgence.asRessource("character/stats")));
    }

    public void method_25393() {
        if (this.statsPanel != null && this.field_22787.field_1687.method_8510() % 20L == 0L) {
            this.fillStats(this.statsPanel);
        }
    }

    protected void build(FlowLayout root) {
        PlayerComponent playerComp = (PlayerComponent)root.childById(PlayerComponent.class, "playerSkin");
        class_1657 player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas((class_1657)player);
        PlayerInventoryData dt1 = (PlayerInventoryData)player.getComponent(Components.PLAYER_INVENTORY);
        dt1.setBackpackStack(((PlayerInventoryData)class_310.method_1551().field_1724.getComponent(Components.PLAYER_INVENTORY)).getBackpackStack());
        dt.getAppearence().clonePlayerAppearance((class_1657)class_310.method_1551().field_1724);
        FlowLayout np = (FlowLayout)root.childById(FlowLayout.class, "namePanel");
        ApiCharacterValues chara = ComponentManager.getPlayerCharacter((class_1657)class_310.method_1551().field_1724).getCurrentCharacter();
        if (chara != null) {
            np.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText(chara.stats.firstname + " " + chara.stats.lastname)).lineHeight(8));
            np.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText(chara.stats.origine)).lineHeight(8));
            np.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText(chara.stats.faction)).lineHeight(8));
            np.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText(chara.stats.job)).lineHeight(8));
        }
        FlowLayout pane = (FlowLayout)root.childById(FlowLayout.class, "listPanel");
        for (String k : CharactersApi.stats().getRoles().keySet()) {
            ClickableLayoutComponent c = new ClickableLayoutComponent(Sizing.fill((int)98), Sizing.fixed((int)20), FlowLayout.Algorithm.HORIZONTAL);
            c.surface(Surface.flat((int)DrawUtils.whithAlpha(DrawUtils.GRAY_GREEN, 255))).padding(Insets.of((int)2)).margins(Insets.of((int)1));
            c.verticalAlignment(VerticalAlignment.CENTER);
            Optional r = CharactersApi.stats().getRole(k);
            IPlayerComponent dtC = ComponentManager.getPlayerDatas((class_1657)this.field_22787.field_1724);
            c.onPress(v -> this.loadInfos((FlowLayout)root.childById(FlowLayout.class, "infosPanel"), k, (StatsRole)r.get()));
            c.child(io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteTitle(((StatsRole)r.get()).name + "   Niv." + dtC.getStats().getLevel(k))).horizontalSizing(Sizing.fill((int)80)));
            ButtonComponent.Renderer btr = ButtonComponent.Renderer.texture((class_2960)GreenResurgence.asRessource("textures/gui/dice.png"), (int)0, (int)0, (int)20, (int)40);
            ButtonComponent bt = io.wispforest.owo.ui.component.Components.button((class_2561)class_2561.method_43470((String)"\ud83c\udfb2"), r1 -> {
                Channels.MAIN.clientHandle().send((Record)new StatsPackets.RollStat(k));
                this.method_25419();
            });
            bt.sizing(Sizing.fixed((int)16));
            bt.tooltip((class_2561)DrawUtils.whiteText("Lancer un d\u00e9s"));
            c.child((Component)bt);
            pane.child((Component)c);
        }
        this.statsPanel = (FreeRowGridLayout)root.childById(FreeRowGridLayout.class, "statsPanel");
        if (this.statsPanel != null) {
            this.fillStats(this.statsPanel);
        }
    }

    private void loadInfos(FlowLayout parent, String roleId, StatsRole role) {
        IPlayerStats st = ComponentManager.getPlayerDatas((class_1657)this.field_22787.field_1724).getStats();
        parent.clearChildren();
        parent.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteTitle(role.name)));
        BarComponent bar = new BarComponent(GreenResurgence.asRessource("textures/gui/hud/stamina.png"), 0, 0, 256, 10, 256, 64, true);
        bar.setFillPercent(CharactersApi.stats().percentOfXpForNext((class_1657)this.field_22787.field_1724, roleId));
        bar.tooltip((class_2561)DrawUtils.whiteText(st.getXp(roleId) + "/" + CharactersApi.stats().getXpCostForLevel(st.getLevel(roleId) + 1) + " xp"));
        bar.horizontalSizing(Sizing.fill((int)90));
        parent.child((Component)bar);
        parent.child((Component)this.paragraph((class_2561)DrawUtils.whiteTextTranslated("green_resurgence.gui.stats.desc." + roleId, new Object[0])));
        this.addGlobalModInfos(parent, role, st.getLevel(roleId));
        int cur = st.getLevel(roleId);
        for (int i = 0; i < role.stages.length; ++i) {
            this.addPalierInfo(parent, role, i, role.stages[i], role.stages[i] <= cur);
        }
    }

    private LabelComponent paragraph(class_2561 text) {
        LabelComponent c = io.wispforest.owo.ui.component.Components.label((class_2561)text);
        c.verticalTextAlignment(VerticalAlignment.CENTER).lineHeight(4).horizontalSizing(Sizing.fill((int)90));
        return c;
    }

    private LabelComponent simple(class_2561 text) {
        LabelComponent c = io.wispforest.owo.ui.component.Components.label((class_2561)text);
        c.verticalTextAlignment(VerticalAlignment.CENTER).lineHeight(6).horizontalSizing(Sizing.fill((int)90));
        return c;
    }

    private void addGlobalModInfos(FlowLayout parent, StatsRole role, int level) {
        Map mods = role.getGlobalModifiers();
        DecimalFormat df = new DecimalFormat("0.#");
        if (!mods.isEmpty()) {
            parent.child(io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.textTranslated("green_resurgence.gui.stats.global_bonus", DrawUtils.ORANGE, new Object[0])).horizontalSizing(Sizing.fill((int)90)));
            class_5250 text = DrawUtils.whiteText("");
            for (Map.Entry p : mods.entrySet()) {
                class_1322 d = (class_1322)((Function)p.getValue()).apply(level);
                text = text.method_27693(" - ").method_10852((class_2561)DrawUtils.whiteTextTranslated(((class_1320)p.getKey()).method_26830(), new Object[0]));
                text = text.method_27693(": +" + df.format(d.method_6186() * 100.0) + "%\n");
            }
            parent.child((Component)this.paragraph((class_2561)text));
        }
    }

    private void addPalierInfo(FlowLayout parent, StatsRole role, int palier, int level, boolean unlocked) {
        StatsRolePalier mods = role.getPalierInfos(palier);
        if (mods != null) {
            parent.child(io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.textTranslated("green_resurgence.gui.stats.palier.title", unlocked ? DrawUtils.ORANGE : DrawUtils.WHITE, palier + 1, level)).horizontalSizing(Sizing.fill((int)90)));
            DecimalFormat df = new DecimalFormat("0.#");
            class_5250 text = DrawUtils.whiteText("");
            for (Map.Entry p : mods.getModifiers().entrySet()) {
                class_1322 d = (class_1322)p.getValue();
                text = text.method_27693(" - ").method_10852((class_2561)DrawUtils.whiteTextTranslated(((class_1320)p.getKey()).method_26830(), new Object[0]));
                text = text.method_27693(": +" + df.format(d.method_6186() * 100.0) + "%\n");
            }
            parent.child((Component)this.paragraph((class_2561)text));
        }
    }

    private void fillStats(FreeRowGridLayout parent) {
        class_746 player = this.field_22787.field_1724;
        PlayerData pdata = (PlayerData)player.getComponent(Components.PLAYER_DATA);
        parent.clear();
        parent.child((Component)this.statLabel("Vie  ", pdata.healthManager.getHealthAmount(), pdata.healthManager.getMaxHealthAmount()));
        parent.child((Component)this.statLabel("Infec ", 0.0, 0.0));
        parent.child((Component)this.statLabel("Shield", pdata.healthManager.getShieldAmount(), pdata.healthManager.getMaxShieldAmount()));
        parent.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText("Faim   : Plein")).lineHeight(8));
        parent.child((Component)this.statLabel("Endu  ", pdata.healthManager.getEnergyAmount(), pdata.healthManager.getMaxEnergyAmount()));
        parent.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText("Soif   : Plein")).lineHeight(8));
        parent.child((Component)this.statLabel("Oxygen", player.method_5669(), player.method_5748()));
        parent.child((Component)io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText("Armure: " + player.method_6096())).lineHeight(8));
    }

    private LabelComponent statLabel(String text, double v1, double v2) {
        DecimalFormat df = new DecimalFormat("0.#");
        LabelComponent c = io.wispforest.owo.ui.component.Components.label((class_2561)DrawUtils.whiteText(text + ": " + df.format(v1) + "/" + df.format(v2))).lineHeight(8);
        c.margins(Insets.right((int)1));
        return c;
    }

    public boolean method_25421() {
        return false;
    }
}

