/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.components.hud.IHideableComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class InventoryComponent
extends BaseComponent
implements IHideableComponent {
    public final class_2960 SLOT_TEXTURE;
    public final String inventoryId;
    public final String name;
    public class_2561 customName;
    protected AnimatableProperty<PositionedRectangle> visibleArea;
    private int regionWidth = 18;
    private int regionHeight = 18;
    protected boolean blend = false;
    private boolean hidden;

    public InventoryComponent(String inventoryId, int width, int height, String name) {
        this.inventoryId = inventoryId;
        this.name = name;
        this.SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/slots/slot.png");
        this.setSize(width, height);
    }

    public InventoryComponent(String inventoryId, int width, int height, String name, String texture) {
        this.inventoryId = inventoryId;
        this.name = name;
        this.SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/slots/" + texture);
        this.setSize(width, height);
    }

    public void setSize(int width, int height) {
        this.regionWidth = width * 18;
        this.regionHeight = (this.getInventoryName() != null ? 10 : 1) + height * 18;
        this.visibleArea = AnimatableProperty.of((Animatable)PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth, (int)this.regionHeight));
        this.applySizing();
        if (this.parent != null) {
            this.parent.onChildMutated((Component)this);
        }
    }

    public InventoryComponent(String inventoryId, int width, int height) {
        this(inventoryId, width, height, inventoryId);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.regionWidth;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.regionHeight;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.visibleArea.update(delta);
    }

    public class_2561 getInventoryName() {
        if (this.customName != null) {
            return this.customName;
        }
        if (this.name.equals("disabled")) {
            return null;
        }
        if (this.inventoryId.equals("player")) {
            return class_2561.method_43471((String)"container.inventory");
        }
        if (this.inventoryId.equals("hotbar") || this.name.isEmpty()) {
            return null;
        }
        return class_2561.method_43471((String)("green_resurgence.container." + this.name));
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.hidden) {
            return;
        }
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        matrices.method_22905((float)this.width / (float)this.regionWidth, (float)this.height / (float)this.regionHeight, 0.0f);
        PositionedRectangle visibleArea = (PositionedRectangle)this.visibleArea.get();
        int bottomEdge = Math.min(visibleArea.y() + visibleArea.height(), this.regionHeight);
        int rightEdge = Math.min(visibleArea.x() + visibleArea.width(), this.regionWidth);
        class_2561 name = this.getInventoryName();
        if (name != null) {
            int d = class_310.method_1551().field_1772.method_1727(name.getString());
            if (this.width() >= d) {
                context.drawText(name, (float)visibleArea.x(), (float)visibleArea.y(), 0.9f, 0xFFFFFF);
            }
        }
        context.method_25293(this.SLOT_TEXTURE, visibleArea.x() - 1, visibleArea.y() + (name != null ? 9 : 0), rightEdge - visibleArea.x(), bottomEdge - visibleArea.y() - (name != null ? 10 : 1), (float)visibleArea.x(), (float)visibleArea.y(), rightEdge - visibleArea.x(), bottomEdge - visibleArea.y() - (name != null ? 10 : 1), 18, 18);
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    public InventoryComponent visibleArea(PositionedRectangle visibleArea) {
        this.visibleArea.set((Object)visibleArea);
        return this;
    }

    public InventoryComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    public boolean blend() {
        return this.blend;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"blend", UIParsing::parseBool, this::blend);
        if (children.containsKey("visible-area")) {
            Map areaChildren = UIParsing.childElements((Element)children.get("visible-area"));
            int x = 0;
            int y = 0;
            int width = this.regionWidth;
            int height = this.regionHeight;
            if (areaChildren.containsKey("x")) {
                x = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("x")));
            }
            if (areaChildren.containsKey("y")) {
                y = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("y")));
            }
            if (areaChildren.containsKey("width")) {
                width = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("width")));
            }
            if (areaChildren.containsKey("height")) {
                height = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("height")));
            }
            this.visibleArea(PositionedRectangle.of((int)x, (int)y, (int)width, (int)height));
        }
    }

    public static InventoryComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"id"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"width"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"height"});
        String text = "slot.png";
        if (element.hasAttribute("texture")) {
            text = element.getAttributeNode("texture").getValue();
        }
        String invId = element.getAttributeNode("id").getValue();
        int w = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("width"));
        int h = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("height"));
        if (element.hasAttribute("name")) {
            return new InventoryComponent(invId, w, h, element.getAttributeNode("name").getValue(), text);
        }
        return new InventoryComponent(invId, w, h, invId, text);
    }

    @Override
    public void hidden(boolean hidden) {
        this.hidden = hidden;
        this.regionWidth = 1;
        this.regionHeight = 1;
        this.visibleArea = AnimatableProperty.of((Animatable)PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth, (int)this.regionHeight));
        this.applySizing();
        if (this.parent != null) {
            this.parent.onChildMutated((Component)this);
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

