/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.components.ScrollPart;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class InventorySearchableComponent
extends BaseComponent {
    public static final class_2960 SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/slots/slot.png");
    public final String inventoryId;
    public final String name;
    private final class_342 textField;
    protected AnimatableProperty<PositionedRectangle> visibleArea;
    private int regionWidth = 18;
    private int regionHeight = 18;
    private int slotsWidth = 2;
    private int slotsHeight = 2;
    protected boolean blend = false;
    private String lastResearch = "";
    private List<class_1735> displayedSlot = new ArrayList<class_1735>();
    private List<class_1735> filteredSlots = new ArrayList<class_1735>();
    private List<class_1735> inventory = new ArrayList<class_1735>();
    private final ScrollPart scroller;

    protected InventorySearchableComponent(String inventoryId, int width, int height, String name) {
        this.inventoryId = inventoryId;
        this.name = name;
        this.scroller = new ScrollPart(this.width - 10, 20, 10, this.height - 20, 1);
        this.scroller.onScroll(this::onScroll);
        this.textField = new class_342(class_310.method_1551().field_1772, 1, 9, this.width, 10, (class_2561)class_2561.method_43473());
        this.textField.method_25365(true);
        this.textField.method_1888(true);
        this.textField.method_1858(false);
        this.setSize(width, height);
    }

    public class_3545<Integer, Integer> getSlotsSize() {
        return new class_3545((Object)this.slotsWidth, (Object)this.slotsHeight);
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    private boolean isOnTextField(double mouseX, double mouseY) {
        return mouseY < 10.0 && mouseX < (double)(this.width - 10);
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
        if (this.scroller.isOver(mouseX, mouseY)) {
            return this.scroller.mouseDrag(mouseY);
        }
        return false;
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseDown(mouseX, mouseY, button);
        }
        return false;
    }

    public void applySizing() {
        super.applySizing();
        this.textField.method_25358(this.width);
        this.scroller.x = this.width - 10;
        this.scroller.y = 20;
        this.scroller.width = 10;
        this.scroller.height = this.height - 20;
        this.refreshSlots();
    }

    private void onScroll(int lines) {
        this.refreshSlots();
    }

    public void setInventory(List<class_1735> inv) {
        this.inventory = inv;
        this.lastResearch = "";
        this.textField.method_1852("");
        this.refreshSearch();
    }

    private void refreshSlots() {
        this.displayedSlot = new ArrayList<class_1735>();
        for (int i1 = this.scroller.scroll * this.slotsWidth; i1 < Math.min(this.scroller.scroll * this.slotsWidth + this.slotsHeight * this.slotsWidth, this.filteredSlots.size()); ++i1) {
            this.displayedSlot.add(this.filteredSlots.get(i1));
        }
        while (this.displayedSlot.size() < this.slotsWidth * this.slotsHeight && !this.displayedSlot.isEmpty()) {
            this.displayedSlot.add(new FalseSlot(this.displayedSlot.size() + 1, 0, 0));
        }
    }

    public List<class_1735> getDisplayedSlots() {
        return this.displayedSlot;
    }

    private void refreshSearch() {
        this.filteredSlots = this.lastResearch.isBlank() ? this.inventory : this.inventory.stream().filter(v -> v.method_7677().method_7964().getString().toLowerCase().trim().contains(this.lastResearch)).toList();
        this.scroller.lines = Math.max(1, this.filteredSlots.size() / this.slotsWidth - this.slotsHeight + 1);
        this.refreshSlots();
    }

    public void setSize(int width, int height) {
        this.slotsWidth = width;
        this.slotsHeight = height;
        this.regionWidth = 10 + width * 18;
        this.regionHeight = 20 + height * 18;
        this.visibleArea = AnimatableProperty.of((Animatable)PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth, (int)this.regionHeight));
        this.applySizing();
        if (this.parent != null) {
            this.parent.inflate(this.parent.fullSize());
        }
    }

    protected InventorySearchableComponent(String inventoryId, int width, int height) {
        this(inventoryId, width, height, inventoryId);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.regionWidth;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.regionHeight;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.visibleArea.update(delta);
        this.textField.update(delta, mouseX, mouseY);
    }

    public class_2561 getInventoryName() {
        if (this.name.equals("disabled")) {
            return null;
        }
        if (this.inventoryId.equals("player")) {
            return class_2561.method_43471((String)"container.inventory");
        }
        if (this.inventoryId.equals("hotbar") || this.name.isEmpty()) {
            return null;
        }
        return class_2561.method_43471((String)("green_resurgence.container." + this.name));
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        matrices.method_22905((float)this.width / (float)this.regionWidth, (float)this.height / (float)this.regionHeight, 0.0f);
        PositionedRectangle visibleArea = (PositionedRectangle)this.visibleArea.get();
        int bottomEdge = Math.min(visibleArea.y() + visibleArea.height(), this.regionHeight);
        int rightEdge = Math.min(visibleArea.x() + visibleArea.width(), this.regionWidth);
        class_2561 name = this.getInventoryName();
        if (name != null) {
            context.drawText(name, (float)visibleArea.x(), (float)visibleArea.y(), 0.9f, 0xFFFFFF);
        }
        context.method_25293(SLOT_TEXTURE, visibleArea.x() - 1, visibleArea.y() + 19, rightEdge - visibleArea.x() - 10, bottomEdge - visibleArea.y() - 20, (float)visibleArea.x(), (float)visibleArea.y(), rightEdge - visibleArea.x() - 10, bottomEdge - visibleArea.y() - 20, 18, 18);
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        context.method_25293(SLOT_TEXTURE, this.textField.method_46426() - 2, this.textField.method_46427() - 1, 2, this.textField.method_25364(), 0.0f, 0.0f, 2, 18, 18, 18);
        context.method_25293(SLOT_TEXTURE, this.textField.method_46426(), this.textField.method_46427() - 1, this.textField.method_25368() - 4, this.textField.method_25364(), 2.0f, 0.0f, 14, 18, 18, 18);
        context.method_25293(SLOT_TEXTURE, this.textField.method_46426() + this.textField.method_25368() - 4, this.textField.method_46427() - 1, 2, this.textField.method_25364(), 16.0f, 0.0f, 2, 18, 18, 18);
        this.scroller.draw((class_332)context);
        this.textField.method_25394((class_332)context, mouseX, mouseY, delta);
        matrices.method_22909();
    }

    public InventorySearchableComponent visibleArea(PositionedRectangle visibleArea) {
        this.visibleArea.set((Object)visibleArea);
        return this;
    }

    public InventorySearchableComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    public boolean blend() {
        return this.blend;
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scroller.scroll((int)amount);
        if (this.isOnTextField(mouseX, mouseY)) {
            return this.textField.onMouseScroll(mouseX, mouseY, amount);
        }
        super.onMouseScroll(mouseX, mouseY, amount);
        return true;
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        boolean v = this.textField.onKeyPress(keyCode, scanCode, modifiers);
        if (!this.textField.method_1882().trim().equals(this.lastResearch)) {
            this.lastResearch = this.textField.method_1882().toLowerCase().trim();
            this.refreshSearch();
        }
        return v;
    }

    public boolean onCharTyped(char chr, int modifiers) {
        boolean v = this.textField.method_25400(chr, modifiers);
        if (!this.textField.method_1882().trim().equals(this.lastResearch)) {
            this.lastResearch = this.textField.method_1882().toLowerCase().trim();
            this.refreshSearch();
        }
        return v;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"blend", UIParsing::parseBool, this::blend);
        if (children.containsKey("visible-area")) {
            Map areaChildren = UIParsing.childElements((Element)children.get("visible-area"));
            int x = 0;
            int y = 0;
            int width = this.regionWidth;
            int height = this.regionHeight;
            if (areaChildren.containsKey("x")) {
                x = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("x")));
            }
            if (areaChildren.containsKey("y")) {
                y = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("y")));
            }
            if (areaChildren.containsKey("width")) {
                width = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("width")));
            }
            if (areaChildren.containsKey("height")) {
                height = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("height")));
            }
            this.visibleArea(PositionedRectangle.of((int)x, (int)y, (int)width, (int)height));
        }
    }

    public static InventorySearchableComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"id"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"width"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"height"});
        String invId = element.getAttributeNode("id").getValue();
        int w = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("width"));
        int h = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("height"));
        if (element.hasAttribute("name")) {
            return new InventorySearchableComponent(invId, w, h, element.getAttributeNode("name").getValue());
        }
        return new InventorySearchableComponent(invId, w, h);
    }

    @Environment(value=EnvType.CLIENT)
    public class FalseSlot
    extends class_1735 {
        public FalseSlot(int index, int x, int y) {
            super((class_1263)new class_1277(new class_1799[]{class_1799.field_8037}), index, x, y);
        }

        public class_1799 method_32756(class_1799 stack) {
            return InventorySearchableComponent.this.inventory.get(0).method_32756(stack);
        }

        public class_1799 method_32755(class_1799 stack, int count) {
            return InventorySearchableComponent.this.inventory.get(0).method_32755(stack, count);
        }

        public boolean method_7680(class_1799 stack) {
            return InventorySearchableComponent.this.inventory.get(0).method_7680(stack);
        }
    }
}

