/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class SearchBoxComponent
extends TextBoxComponent {
    private final Map<String, BaseParentComponent> list = new HashMap<String, BaseParentComponent>();
    private String selected;
    private boolean inited = false;
    private int resizedAt = -1;
    private final Map<String, BaseParentComponent> filteredList = new HashMap<String, BaseParentComponent>();
    private int totalHeight = 0;
    private int offset = 0;
    private Size space;

    protected SearchBoxComponent(Sizing horizontalSizing) {
        super(horizontalSizing);
        this.textValue.observe(v -> {
            this.selected = null;
            this.offset = 0;
            this.updateContent();
        });
    }

    public void setOptions(Map<String, BaseParentComponent> options) {
        this.list.clear();
        this.list.putAll(options);
        this.updateContent();
    }

    public String getSelected() {
        return this.selected;
    }

    public void onClickMenu(double mouseX, double mouseY) {
        for (Map.Entry<String, BaseParentComponent> c : this.filteredList.entrySet()) {
            if (!c.getValue().isInBoundingBox(mouseX, mouseY)) continue;
            this.method_1852(c.getKey());
            this.selected = c.getKey();
            this.updateContent();
            this.method_25365(true);
            this.method_1888(true);
            return;
        }
    }

    public void inflate(Size space) {
        super.inflate(space);
        this.space = space;
        this.inited = true;
        this.resizedAt = 2;
        this.method_1865();
    }

    public void method_1865() {
        super.method_1865();
        if (this.resizedAt > -1) {
            --this.resizedAt;
            if (this.resizedAt == 0) {
                this.updateContent();
                this.resizedAt = -1;
            }
        }
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.offset = (int)Math.min(Math.max(0.0, (double)this.offset - amount), (double)(this.list.size() - 1));
        this.updateContent();
        return true;
    }

    private void updateContent() {
        List ls;
        if (!this.inited) {
            return;
        }
        this.filteredList.clear();
        String txt = ((String)this.textValue.get()).toLowerCase();
        if (this.selected != null || txt.isEmpty()) {
            this.totalHeight = 0;
            return;
        }
        Stream l = txt.isBlank() ? this.list.keySet().stream() : this.list.keySet().stream().filter(v1 -> v1.toLowerCase().contains(txt)).sorted();
        int i = this.y();
        this.totalHeight = 0;
        int d = -1;
        if (this.space != null) {
            d = this.space.height() - (this.height() + 2);
        }
        if ((ls = l.toList()).isEmpty()) {
            this.totalHeight = 0;
            return;
        }
        if (this.offset < 0) {
            this.offset = 0;
        }
        if (this.offset >= ls.size()) {
            this.offset = ls.size() - 1;
        }
        for (int j = this.offset; j < ls.size(); ++j) {
            String t1 = (String)ls.get(j);
            BaseParentComponent comp = this.list.get(t1);
            comp.inflate(Size.of((int)this.field_22758, (int)this.field_22759));
            i += comp.height();
            this.totalHeight += comp.height();
            if (d > -1 && this.totalHeight >= d) break;
            comp.mount(null, this.x(), i);
            this.filteredList.put(t1, comp);
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        OwoUIDrawContext ctx = OwoUIDrawContext.of((class_332)context);
        ctx.drawGradientRect(this.x(), this.y() + this.field_22759, this.width(), this.totalHeight, -1072689136, -1072689136, -804253680, -804253680);
        super.method_48579(context, mouseX, mouseY, delta);
        for (BaseParentComponent comp : this.filteredList.values()) {
            comp.draw(ctx, mouseX, mouseY, 0.0f, delta);
        }
    }
}

