/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.faction;

import com.diamssword.characters.api.CharactersApi;
import com.diamssword.characters.api.PlayerPresence;
import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.IPacketNotifiedChange;
import com.diamssword.greenresurgence.gui.components.ClickableLayoutComponent;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.GuildPackets;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionMember;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class FactionFriendAddGui
extends BaseUIModelScreen<FlowLayout>
implements IPacketNotifiedChange {
    public static final class_2960 MISSING_HEAD = GreenResurgence.asRessource("textures/gui/missing_head.png");
    public static final class_2960 GUILD_HEAD = GreenResurgence.asRessource("textures/gui/guild_head.png");
    private int needChange = -1;
    private FlowLayout list;
    private FlowLayout menu;
    private String filterText = "";
    private final UUID id;
    private final Map<UUID, String> guilds;

    public FactionFriendAddGui(UUID uuid, Map<UUID, String> guilds) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)GreenResurgence.asRessource("faction/friend_add")));
        this.id = uuid;
        this.guilds = guilds;
    }

    public void method_25393() {
        super.method_25393();
        if (this.needChange > -1) {
            --this.needChange;
            if (this.needChange == 0) {
                this.addOffline(this.filterText, this.list);
                this.needChange = -1;
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    protected void build(FlowLayout rootComponent) {
        TextBoxComponent search = (TextBoxComponent)rootComponent.childById(TextBoxComponent.class, "search");
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "back")).onPress(v -> Channels.MAIN.clientHandle().send((Record)new GuildPackets.RequestGui("friends", this.id)));
        this.menu = (FlowLayout)rootComponent.childById(FlowLayout.class, "contextMenu");
        search.method_47404((class_2561)class_2561.method_43470((String)"Recherche"));
        this.list = (FlowLayout)rootComponent.childById(FlowLayout.class, "list");
        search.onChanged().subscribe(v -> this.refreshSearch(v, this.list));
        this.refreshSearch(search.method_1882(), this.list);
    }

    private void refreshSearch(String text, FlowLayout parent) {
        if (!text.isBlank() && !text.isEmpty()) {
            this.filterText = text;
            this.needChange = 30;
        }
        parent.clearChildren();
        this.addPlayers(text.toLowerCase(), parent);
        if (text.startsWith("#")) {
            this.addGuilds(text.substring(1).toLowerCase(), parent);
        }
    }

    private void updateSelectedMenu(FactionMember member, class_2960 texture) {
        this.menu.clearChildren();
        this.menu.gap(4);
        this.menu.sizing(Sizing.fill((int)40), Sizing.content());
        this.menu.horizontalAlignment(HorizontalAlignment.CENTER);
        this.menu.child(Components.texture((class_2960)texture, (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)32)));
        LabelComponent t = Components.label((class_2561)class_2561.method_43470((String)member.getName()));
        if (member.getName().length() > 15) {
            t.horizontalSizing(Sizing.fill((int)100));
        }
        this.menu.child((Component)t);
        this.menu.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Inviter"), v -> Channels.MAIN.clientHandle().send((Record)new GuildPackets.InviteMember(member))));
    }

    private void addPlayers(String filter, FlowLayout parent) {
        Stream<class_640> pls = this.field_22787.field_1724.field_3944.method_45732().stream().filter(v -> !v.method_2966().getId().equals(this.field_22787.field_1724.method_5667()));
        if (!filter.isEmpty() && !filter.isBlank()) {
            pls = pls.filter(v -> v.method_2966().getName().toLowerCase().contains(filter));
        }
        for (class_640 n : pls.toList()) {
            ClickableLayoutComponent l = new ClickableLayoutComponent(Sizing.fill((int)100), Sizing.fixed((int)20), FlowLayout.Algorithm.HORIZONTAL);
            AtomicReference<class_2960> texture = new AtomicReference<class_2960>(MISSING_HEAD);
            l.onPress(v -> this.updateSelectedMenu(new FactionMember(n.method_2966().getId(), n.method_2966().getName(), false), (class_2960)texture.get()));
            Component icon = Components.texture((class_2960)texture.get(), (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16));
            l.child(icon);
            l.gap(4).padding(Insets.horizontal((int)2));
            l.child((Component)Components.label((class_2561)class_2561.method_43470((String)n.method_2966().getName())));
            l.surface(Surface.PANEL);
            l.surface2(Surface.DARK_PANEL);
            l.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
            CharactersApi.skin().getHeadTexture(n.method_2966().getId(), v -> {
                texture.set((class_2960)v);
                l.removeChild(icon);
                l.child(0, Components.texture((class_2960)((class_2960)texture.get()), (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16)));
            });
            parent.child((Component)l);
        }
    }

    private void addGuilds(String filter, FlowLayout parent) {
        Stream<Object> pls = this.guilds.entrySet().stream();
        if (!filter.isEmpty() && !filter.isBlank()) {
            pls = pls.filter(v -> ((String)v.getValue()).toLowerCase().contains(filter));
        }
        for (Map.Entry n : pls.toList()) {
            ClickableLayoutComponent l = new ClickableLayoutComponent(Sizing.fill((int)100), Sizing.fixed((int)20), FlowLayout.Algorithm.HORIZONTAL);
            l.child(Components.texture((class_2960)GUILD_HEAD, (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16)));
            l.onPress(v -> this.updateSelectedMenu(new FactionMember((UUID)n.getKey(), (String)n.getValue(), true), GUILD_HEAD));
            l.gap(4).padding(Insets.horizontal((int)2));
            l.child((Component)Components.label((class_2561)class_2561.method_43470((String)("#" + (String)n.getValue()))));
            l.surface(Surface.PANEL);
            l.surface2(Surface.DARK_PANEL);
            l.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
            parent.child((Component)l);
        }
    }

    private void addOffline(String filter, FlowLayout parent) {
        CharactersApi.skin().requestPlayerProfiles(filter).thenAccept(v -> {
            for (Map.Entry d : v.entrySet()) {
                AtomicReference<class_2960> texture = new AtomicReference<class_2960>(MISSING_HEAD);
                ClickableLayoutComponent l = new ClickableLayoutComponent(Sizing.fill((int)100), Sizing.fixed((int)20), FlowLayout.Algorithm.HORIZONTAL);
                Component icon = Components.texture((class_2960)MISSING_HEAD, (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16));
                l.child(icon);
                l.onPress(v1 -> this.updateSelectedMenu(new FactionMember((UUID)d.getKey(), ((PlayerPresence)d.getValue()).username(), false), (class_2960)texture.get()));
                l.gap(4).padding(Insets.horizontal((int)2));
                l.child((Component)Components.label((class_2561)class_2561.method_43470((String)((PlayerPresence)d.getValue()).characterName())));
                l.surface(Surface.PANEL);
                l.surface2(Surface.DARK_PANEL);
                l.alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
                CharactersApi.skin().getHeadTexture((UUID)d.getKey(), v1 -> {
                    texture.set((class_2960)v1);
                    l.removeChild(icon);
                    l.child(0, Components.texture((class_2960)v1, (int)0, (int)0, (int)8, (int)8, (int)8, (int)8).sizing(Sizing.fixed((int)16)));
                });
                parent.child(0, (Component)l);
            }
        });
    }

    @Override
    public void onChangeReceived(String topic, String value) {
        if (topic.equals("addMember")) {
            this.menu.clearChildren();
            this.menu.child((Component)Components.label((class_2561)class_2561.method_43470((String)(value + " \u00e0 \u00e9t\u00e9 ajout\u00e9!"))));
        }
    }

    @Override
    public void onErrorReceived(String topic, class_2561 message) {
        if (topic.equals("addMember")) {
            this.menu.clearChildren();
            this.menu.child((Component)Components.label((class_2561)message));
        }
    }
}

