/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.playerContainers;

import com.diamssword.greenresurgence.blocks.CrafterBlock;
import com.diamssword.greenresurgence.gui.components.ButtonInventoryComponent;
import com.diamssword.greenresurgence.gui.components.RecipDisplayComponent;
import com.diamssword.greenresurgence.gui.playerContainers.PlayerBasedGui;
import com.diamssword.greenresurgence.network.CraftPackets;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class CrafterScreen
extends PlayerBasedGui<CrafterBlock.ScreenHandler> {
    public CrafterScreen(CrafterBlock.ScreenHandler handler, class_1661 inv, class_2561 title) {
        super(handler, "survival/crafter");
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        super.build(rootComponent);
        ButtonInventoryComponent ls = (ButtonInventoryComponent)rootComponent.childById(ButtonInventoryComponent.class, "list");
        RecipDisplayComponent disp = (RecipDisplayComponent)rootComponent.childById(RecipDisplayComponent.class, "display");
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "craft")).onPress(v -> {
            SimpleRecipe r = disp.getRecipe();
            if (r != null && (disp.getStatus() == null || disp.getStatus().canCraft)) {
                CraftPackets.sendCraftRequest(r, ((CrafterBlock.ScreenHandler)this.handler).getPos());
            }
        });
        ls.onRecipePicked().subscribe((v, a, b) -> {
            disp.setRecipe(v);
            CraftPackets.requestStatus(v, ((CrafterBlock.ScreenHandler)this.handler).getPos(), disp::setCraftingStatus);
            return true;
        });
        ((CrafterBlock.ScreenHandler)this.handler).onReady(un -> Recipes.get(ls.collectionID).ifPresent(v -> {
            List<SimpleRecipe> ls1 = v.getRecipes((class_1657)this.field_22787.field_1724);
            if (!ls1.isEmpty()) {
                SimpleRecipe r = ls1.get(0);
                disp.setRecipe(r);
                CraftPackets.requestStatus(r, ((CrafterBlock.ScreenHandler)this.handler).getPos(), disp::setCraftingStatus);
            }
        }));
    }

    @Override
    protected void drawBackground(class_332 ctx, float delta, int mouseY, int mouseX) {
    }
}

