/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.playerContainers;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.containers.player.VanillaPlayerInvMokup;
import com.diamssword.greenresurgence.gui.components.ClickableLayoutComponent;
import com.diamssword.greenresurgence.gui.components.ItemCooldownComponent;
import com.diamssword.greenresurgence.gui.components.hud.IconComponent;
import com.diamssword.greenresurgence.gui.playerContainers.PlayerBasedGui;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.CraftPackets;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerInventoryData;
import com.diamssword.greenresurgence.systems.crafting.RecipeCollection;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.TimedCraftingProvider;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class PlayerInventoryGui
extends PlayerBasedGui<VanillaPlayerInvMokup> {
    private PlayerInventoryData playerinv;
    private ClickableLayoutComponent last;
    private static final Supplier<IconComponent> arrow_c = () -> (IconComponent)new IconComponent(GreenResurgence.asRessource("textures/gui/craft/arrow.png"), 0, 0, 32, 32, 32, 32).sizing(Sizing.fixed((int)12), Sizing.fixed((int)16));

    public PlayerInventoryGui(VanillaPlayerInvMokup handler, class_1661 inv, class_2561 title) {
        super(handler, "survival/player_craft");
        this.openSubPanelOnLoad = true;
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        super.build(rootComponent);
        FlowLayout ls = (FlowLayout)rootComponent.childById(FlowLayout.class, "recipeMenu");
        FlowLayout queue = (FlowLayout)rootComponent.childById(FlowLayout.class, "recipeProgress");
        Optional<RecipeCollection> collection = Recipes.get(GreenResurgence.asRessource("player"));
        if (collection.isPresent()) {
            List<SimpleRecipe> recipes = collection.get().getRecipes((class_1657)this.field_22787.field_1724);
            for (SimpleRecipe rec : recipes) {
                ls.child((Component)this.create(rec));
            }
        }
        this.playerinv = (PlayerInventoryData)this.field_22787.field_1724.getComponent(Components.PLAYER_INVENTORY);
        this.playerinv.getCrafterProvider().onNewRecipeQueued(() -> this.redrawQueue(queue, this.playerinv.getCrafterProvider()));
        this.redrawQueue(queue, this.playerinv.getCrafterProvider());
    }

    private void redrawQueue(FlowLayout container, TimedCraftingProvider provider) {
        container.clearChildren();
        this.last = null;
        HashMap stacks = new HashMap();
        provider.getPendingCrafts().forEach(v -> {
            class_1799 r = v.recipe.result((class_1657)this.field_22787.field_1724).getCurrentItem(this.field_22787.method_47600());
            if (stacks.containsKey(r.method_7909())) {
                class_1799 st = (class_1799)stacks.get(r.method_7909());
                st.method_7939(st.method_7947() + r.method_7947());
            } else {
                stacks.put(r.method_7909(), r);
            }
        });
        for (class_1799 st : stacks.values()) {
            ClickableLayoutComponent k = this.addQueue(st);
            container.child((Component)k);
            if (this.last != null) continue;
            this.last = k;
        }
    }

    public ClickableLayoutComponent create(SimpleRecipe recipe) {
        ClickableLayoutComponent cli = new ClickableLayoutComponent(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        cli.onPress(c -> Channels.MAIN.clientHandle().send((Record)new CraftPackets.RequestPlayerCraft(recipe)));
        cli.cursorStyle(CursorStyle.HAND).sizing(Sizing.fill((int)100), Sizing.content());
        cli.alignment(HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
        cli.surface2(Surface.VANILLA_TRANSLUCENT.and(Surface.outline((int)-993410049)));
        cli.gap(2).padding(Insets.of((int)2)).surface(Surface.VANILLA_TRANSLUCENT).margins(Insets.vertical((int)1));
        List<UniversalResource> ings = recipe.ingredients((class_1657)this.field_22787.field_1724);
        for (UniversalResource ing : ings) {
            if (!ing.getType().isItem) continue;
            cli.child((Component)io.wispforest.owo.ui.component.Components.item((class_1799)ing.getCurrentItem(this.field_22787.method_47600())).showOverlay(true).setTooltipFromStack(true));
        }
        cli.child((Component)arrow_c.get());
        UniversalResource res = recipe.result((class_1657)this.field_22787.field_1724);
        if (res.getType().isItem) {
            cli.child((Component)io.wispforest.owo.ui.component.Components.item((class_1799)res.getCurrentItem(this.field_22787.method_47600())).showOverlay(true).setTooltipFromStack(true));
        }
        return cli;
    }

    @Override
    protected void handledScreenTick() {
        Object e;
        super.handledScreenTick();
        if (this.playerinv != null && this.last != null && (e = this.last.children().get(0)) instanceof ItemCooldownComponent) {
            ItemCooldownComponent co = (ItemCooldownComponent)((Object)e);
            co.setCooldown(this.playerinv.getCrafterProvider().getCraftProgress());
        }
    }

    public ClickableLayoutComponent addQueue(class_1799 stack) {
        ClickableLayoutComponent cli = new ClickableLayoutComponent(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        cli.child((Component)new ItemCooldownComponent(stack).showOverlay(true).setTooltipFromStack(true));
        return cli;
    }

    @Override
    protected void drawBackground(class_332 var1, float var2, int var3, int var4) {
    }
}

