/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.materials;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.MItems;
import com.diamssword.greenresurgence.items.MaterialItem;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public class MaterialSet {
    public static final Map<String, MaterialSet> sets = new HashMap<String, MaterialSet>();
    public final String material;
    private final Map<Integer, String> tiersLabel = new HashMap<Integer, String>();
    private final Map<class_2960, MaterialItem> items = new HashMap<class_2960, MaterialItem>();
    private final Map<class_2960, class_3545<String, String>> translates = new HashMap<class_2960, class_3545<String, String>>();
    private final List<class_1792> is3D = new ArrayList<class_1792>();

    public static MaterialSet createSet(String material) {
        MaterialSet m = new MaterialSet(material);
        sets.put(material, m);
        return m;
    }

    private MaterialSet(String material) {
        this.material = material;
    }

    public static void registerLangs(FabricLanguageProvider.TranslationBuilder builder) {
        sets.forEach((m, v) -> {
            v.translates.forEach((i, p) -> {
                builder.add((class_1792)v.items.get(i), (String)p.method_15442());
                builder.add("desc." + i.method_12836() + "." + i.method_12832(), (String)p.method_15441());
            });
            v.getTiers().forEach(v1 -> {
                String s = v.tiersLabel.get(v1);
                builder.add("desc.green_resurgence.materials.tier." + v1 + "." + v.material, s != null ? s : "");
            });
        });
    }

    public class_1792 get(String name) {
        return this.items.get(GreenResurgence.asRessource("material_" + this.material + "_" + name));
    }

    public static void registerModels(class_4915 builder) {
        sets.forEach((m, v) -> v.items.forEach((i, it) -> {
            if (!v.is3D.contains(it)) {
                new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006}).method_25852(class_4941.method_25840((class_1792)it), class_4944.method_25895((class_2960)new class_2960("green_resurgence", "item/materials/" + i.method_12832().replace("material_", ""))), builder.field_22844);
            }
        }));
    }

    public List<Integer> getTiers() {
        ArrayList<Integer> ls = new ArrayList<Integer>();
        this.items.forEach((n, i) -> {
            if (!ls.contains(i.tier)) {
                ls.add(i.tier);
            }
        });
        return ls;
    }

    public List<MaterialItem> getItems() {
        return new ArrayList<MaterialItem>(this.items.values());
    }

    public MaterialSet setTierLabel(int tier, String label) {
        this.tiersLabel.put(tier, label);
        return this;
    }

    public MaterialSet add(int tier, String id, String name, String desc) {
        return this.add(tier, id, name, desc, false);
    }

    public MaterialSet add(int tier, String id, String name, String desc, boolean is3D) {
        return this.add(tier, id, name, desc, is3D, MaterialItem::new);
    }

    public MaterialSet add(int tier, String id, String name, String desc, boolean is3D, MaterialItemFactory itemFactory) {
        class_2960 idd = GreenResurgence.asRessource("material_" + this.material + "_" + id);
        MaterialItem it = itemFactory.create(new OwoItemSettings().group(MItems.GROUP).tab(3), tier, id, this.material);
        this.translates.put(idd, (class_3545<String, String>)new class_3545((Object)name, (Object)desc));
        this.items.put(idd, it);
        if (is3D) {
            this.is3D.add(it);
        }
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)idd, (Object)((Object)it));
        return this;
    }

    @FunctionalInterface
    public static interface MaterialItemFactory {
        public MaterialItem create(OwoItemSettings var1, int var2, String var3, String var4);
    }
}

