/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.mixin.client;

import com.diamssword.greenresurgence.gui.components.Panels;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
@Mixin(value={Surface.class})
public interface OwOSurfaceMixin {
    @Inject(at={@At(value="HEAD")}, method={"parse"}, remap=false, cancellable=true)
    private static void parse(Element surfaceElement, CallbackInfoReturnable<Surface> cir) {
        List children = UIParsing.allChildrenOfType((Element)surfaceElement, (short)1);
        Surface surface = Surface.BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "gpanel" -> surface.and(child.getAttribute("white").equalsIgnoreCase("true") ? Panels.PANEL_WHITE : Panels.PANEL);
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? Surface.DARK_PANEL : Surface.PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes((Element)child, (String[])new String[]{"texture-width", "texture-height"});
                    yield surface.and(Surface.tiled((class_2960)UIParsing.parseIdentifier((Node)child), (int)UIParsing.parseUnsignedInt((Node)child.getAttributeNode("texture-width")), (int)UIParsing.parseUnsignedInt((Node)child.getAttributeNode("texture-height"))));
                }
                case "blur" -> {
                    UIParsing.expectAttributes((Element)child, (String[])new String[]{"size", "quality"});
                    yield surface.and(Surface.blur((float)UIParsing.parseFloat((Node)child.getAttributeNode("quality")), (float)UIParsing.parseFloat((Node)child.getAttributeNode("size"))));
                }
                case "options-background" -> surface.and(Surface.OPTIONS_BACKGROUND);
                case "vanilla-translucent" -> surface.and(Surface.VANILLA_TRANSLUCENT);
                case "panel-inset" -> surface.and(Surface.PANEL_INSET);
                case "tooltip" -> surface.and(Surface.TOOLTIP);
                case "outline" -> surface.and(Surface.outline((int)Color.parseAndPack((Node)child)));
                case "flat" -> surface.and(Surface.flat((int)Color.parseAndPack((Node)child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
            cir.setReturnValue((Object)surface);
        }
    }
}

