/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.render.images;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    public static int getArgb(int a, int red, int green, int blue) {
        return a << 24 | red << 16 | green << 8 | blue;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static float getAlphaFloat(int argb) {
        return (float)RenderUtils.getAlpha(argb) / 255.0f;
    }

    public static float getRedFloat(int argb) {
        return (float)RenderUtils.getRed(argb) / 255.0f;
    }

    public static float getGreenFloat(int argb) {
        return (float)RenderUtils.getGreen(argb) / 255.0f;
    }

    public static float getBlueFloat(int argb) {
        return (float)RenderUtils.getBlue(argb) / 255.0f;
    }
}

