/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.armor;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.network.DictionaryPackets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ArmorLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static ArmorLoader loader = new ArmorLoader();
    private final List<ArmorModelInfos> modeles = new ArrayList<ArmorModelInfos>();
    private final Map<String, ArmorModelDef> modelsBind = new HashMap<String, ArmorModelDef>();
    private boolean shouldSync = false;

    public Optional<ArmorModelDef> getModel(String id) {
        return Optional.ofNullable(this.modelsBind.get(id));
    }

    public Map<String, ArmorModelDef> getModels() {
        return this.modelsBind;
    }

    public static boolean isSLotValidFor(ArmorModelDef model, class_1304 slot) {
        for (class_1304 equipmentSlot : model.slots) {
            if (equipmentSlot != slot) continue;
            return true;
        }
        return false;
    }

    public class_2960 getFabricId() {
        return GreenResurgence.asRessource("armor.json");
    }

    public void method_14491(class_3300 manager) {
        this.modeles.clear();
        class_2960 id = GreenResurgence.asRessource("armor_models.json");
        List files = manager.method_14489(id);
        files.forEach(file -> {
            try {
                BufferedReader reader = file.method_43039();
                try {
                    JsonArray jsonElement = (JsonArray)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonArray.class);
                    jsonElement.forEach(v -> {
                        JsonObject ob = v.getAsJsonObject();
                        String[] models = null;
                        if (ob.has("models")) {
                            models = ob.get("models").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList().toArray(new String[0]);
                        } else if (ob.has("model")) {
                            models = new String[]{ob.get("model").getAsString()};
                        }
                        String[] textures = new String[]{};
                        if (ob.has("textures")) {
                            textures = ob.get("textures").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList().toArray(new String[0]);
                        }
                        class_1304[] slots = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
                        if (ob.has("slots")) {
                            try {
                                slots = (class_1304[])ob.get("slots").getAsJsonArray().asList().stream().map(v1 -> class_1304.method_5924((String)v1.getAsString())).toArray(class_1304[]::new);
                            }
                            catch (IllegalArgumentException e) {
                                LOGGER.error("failed to parse slots ", (Throwable)e);
                            }
                        }
                        if (models != null && models.length > 0) {
                            this.modeles.add(new ArmorModelInfos(models, textures, slots));
                        } else {
                            LOGGER.error("An empty model declaration have been found for " + String.valueOf(this.getFabricId()));
                        }
                    });
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, this.getFabricId(), exception});
            }
        });
    }

    public void bindModels() {
        this.modelsBind.clear();
        this.modeles.forEach(c -> {
            for (String model : c.models) {
                if (c.textures.length == 0) {
                    this.modelsBind.put(model, new ArmorModelDef(model, model, c.slots));
                    continue;
                }
                for (String texture : c.textures) {
                    this.modelsBind.put(model + "_" + texture, new ArmorModelDef(model, texture, c.slots));
                }
            }
        });
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.serverHandle(server).send((Record)new DictionaryPackets.ArmorList(this));
            this.bindModels();
        }
    }

    public static void serializer(class_2540 write, ArmorLoader val) {
        JsonArray arr = new JsonArray();
        val.modeles.forEach(u -> arr.add(GSON.toJson(u)));
        write.method_10814(arr.toString());
    }

    public static ArmorLoader unserializer(class_2540 read) {
        ArmorLoader loader = new ArmorLoader();
        try {
            JsonArray list = (JsonArray)class_3518.method_15284((Gson)GSON, (String)read.method_19772(), JsonArray.class);
            list.forEach(el -> {
                ArmorModelInfos js = (ArmorModelInfos)GSON.fromJson(el.getAsString(), ArmorModelInfos.class);
                loader.modeles.add(js);
            });
        }
        catch (Exception e) {
            LOGGER.error("Couldn't parse packet data for ArmorLoader: ", (Throwable)e);
        }
        return loader;
    }

    public record ArmorModelDef(String model, String texture, class_1304[] slots) {
    }

    public record ArmorModelInfos(String[] models, String[] textures, class_1304[] slots) {
    }
}

