/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.crafting;

import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.crafting.CraftingResult;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.diamssword.greenresurgence.systems.faction.perimeter.FactionList;
import com.diamssword.greenresurgence.systems.faction.perimeter.components.FactionZone;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class CraftingProvider {
    Storage<ItemVariant>[] itemStorages = new Storage[0];
    Storage<FluidVariant>[] fluidStorages = new Storage[0];

    public final CraftingProvider setInventories(Storage<ItemVariant> ... storages) {
        this.itemStorages = storages;
        return this;
    }

    public final CraftingProvider setForFaction(class_1657 player, class_2338 pos) {
        FactionList ls = (FactionList)player.method_37908().getComponent(Components.BASE_LIST);
        ls.getTerrainAt((class_2382)pos).ifPresent(t -> this.setInventories(new Storage[]{InventoryStorage.of((class_1263)player.method_31548(), null), InventoryStorage.of((class_1263)t.getOwner().storage, null)}));
        return this;
    }

    public final CraftingProvider setForTerrain(FactionZone terrain, @Nullable class_1657 player) {
        if (player != null) {
            this.setInventories(new Storage[]{InventoryStorage.of((class_1263)player.method_31548(), null), InventoryStorage.of((class_1263)terrain.getOwner().storage, null)});
        } else {
            this.setInventories(new Storage[]{InventoryStorage.of((class_1263)terrain.getOwner().storage, null)});
        }
        return this;
    }

    public CraftingProvider setTanks(Storage<FluidVariant> ... storages) {
        this.fluidStorages = storages;
        return this;
    }

    public boolean craftRecipe(SimpleRecipe recipe, class_1657 player) {
        List<UniversalResource> ingrs = recipe.ingredients(player);
        boolean complete = true;
        try (Transaction t1 = Transaction.openOuter();){
            for (UniversalResource ingr : ingrs) {
                if (ingr.getType().isItem) {
                    if (this.hasItem(ingr, (TransactionContext)t1, null)) continue;
                    complete = false;
                    continue;
                }
                if (ingr.getType().isFluid) {
                    if (this.hasFluid(ingr, (TransactionContext)t1, null)) continue;
                    complete = false;
                    continue;
                }
                complete = false;
            }
            if (!complete) {
                t1.abort();
            } else {
                t1.commit();
            }
        }
        if (complete) {
            UniversalResource res = recipe.result(player);
            if (res.getType().isItem && !player.method_7270(res.asItem())) {
                player.method_7328(res.asItem(), true);
            }
            return true;
        }
        return false;
    }

    public CraftingResult getRecipeStatus(SimpleRecipe recipe, @Nullable class_1657 player) {
        HashMap<UniversalResource, Boolean> status = new HashMap<UniversalResource, Boolean>();
        List<UniversalResource> ingrs = recipe.ingredients(player);
        boolean complete = true;
        try (Transaction t1 = Transaction.openOuter();){
            for (UniversalResource ingr : ingrs) {
                boolean d;
                if (ingr.getType().isItem) {
                    d = this.hasItem(ingr, (TransactionContext)t1, null);
                    status.put(ingr, d);
                    if (d) continue;
                    complete = false;
                    continue;
                }
                if (ingr.getType().isFluid) {
                    d = this.hasFluid(ingr, (TransactionContext)t1, null);
                    status.put(ingr, d);
                    if (d) continue;
                    complete = false;
                    continue;
                }
                complete = false;
            }
            t1.abort();
        }
        return new CraftingResult(complete, status);
    }

    public boolean hasFluid(UniversalResource r, TransactionContext ctx, @Nullable Storage<FluidVariant> collector) {
        long missing = r.getAmount();
        for (Storage<FluidVariant> fluidStorage : this.fluidStorages) {
            for (class_3611 stack : r.getAllFluids()) {
                long ex = fluidStorage.extract((Object)FluidVariant.of((class_3611)stack, (class_2487)r.extra()), missing, ctx);
                missing -= ex;
                if (collector != null) {
                    collector.insert((Object)FluidVariant.of((class_3611)stack), ex, ctx);
                }
                if (missing > 0L) continue;
                return true;
            }
        }
        return missing <= 0L;
    }

    public boolean hasItem(UniversalResource r, TransactionContext ctx, @Nullable Storage<ItemVariant> collector) {
        long missing = r.getAmount();
        for (Storage<ItemVariant> itemStorage : this.itemStorages) {
            for (class_1799 stack : r.getAllStacks()) {
                long ex = itemStorage.extract((Object)ItemVariant.of((class_1799)stack), missing, ctx);
                missing -= ex;
                if (collector != null) {
                    collector.insert((Object)ItemVariant.of((class_1799)stack), ex, ctx);
                }
                if (missing > 0L) continue;
                return true;
            }
        }
        return missing <= 0L;
    }
}

