/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import com.diamssword.greenresurgence.items.SimpleEnergyItemTiered;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.DelegatingEnergyStorage;

public class EquipmentEnergyStorage
implements EnergyStorage {
    private final ContainerItemContext ctx;
    private final long capacity;
    private final long maxInsert;
    private final long maxExtract;

    public static EnergyStorage createEquipmentStorage(ContainerItemContext ctx, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SimpleEnergyItemTiered) {
            SimpleEnergyItemTiered tiered = (SimpleEnergyItemTiered)class_17922;
            long cap = tiered.getEnergyCapacity(stack);
            StoragePreconditions.notNegative((long)cap);
            long maxI = tiered.getEnergyMaxInput(stack);
            StoragePreconditions.notNegative((long)maxI);
            long maxO = tiered.getEnergyMaxOutput(stack);
            StoragePreconditions.notNegative((long)maxO);
            class_1792 startingItem = ctx.getItemVariant().getItem();
            return new DelegatingEnergyStorage((EnergyStorage)new EquipmentEnergyStorage(ctx, cap, maxI, maxO), () -> ctx.getItemVariant().isOf((Object)startingItem) && ctx.getAmount() > 0L);
        }
        throw new IllegalArgumentException("Item is not a  SimpleEnergyItemTiered: " + String.valueOf(stack.method_7909()));
    }

    private EquipmentEnergyStorage(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        this.ctx = ctx;
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    private boolean trySetEnergy(long energyAmountPerCount, long count, TransactionContext transaction) {
        class_1799 newStack = this.ctx.getItemVariant().toStack();
        SimpleEnergyItemTiered tiered = (SimpleEnergyItemTiered)newStack.method_7909();
        tiered.setStoredEnergy(newStack, energyAmountPerCount);
        ItemVariant newVariant = ItemVariant.of((class_1799)newStack);
        try (Transaction nested = transaction.openNested();){
            if (this.ctx.extract(this.ctx.getItemVariant(), count, (TransactionContext)nested) == count && this.ctx.insert(newVariant, count, (TransactionContext)nested) == count) {
                nested.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean supportsInsertion() {
        return this.maxInsert > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long currentAmountPerCount;
        long count = this.ctx.getAmount();
        long maxAmountPerCount = maxAmount / count;
        long insertedPerCount = Math.min(this.maxInsert, Math.min(maxAmountPerCount, this.capacity - (currentAmountPerCount = this.getAmount() / count)));
        if (insertedPerCount > 0L && this.trySetEnergy(currentAmountPerCount + insertedPerCount, count, transaction)) {
            return insertedPerCount * count;
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        long currentAmountPerCount;
        long count = this.ctx.getAmount();
        long maxAmountPerCount = maxAmount / count;
        long extractedPerCount = Math.min(this.maxExtract, Math.min(maxAmountPerCount, currentAmountPerCount = this.getAmount() / count));
        if (extractedPerCount > 0L && this.trySetEnergy(currentAmountPerCount - extractedPerCount, count, transaction)) {
            return extractedPerCount * count;
        }
        return 0L;
    }

    public long getAmount() {
        class_1799 newStack = this.ctx.getItemVariant().toStack();
        SimpleEnergyItemTiered tiered = (SimpleEnergyItemTiered)newStack.method_7909();
        long stored = tiered.getStoredEnergy(newStack);
        return this.ctx.getAmount() * stored;
    }

    public long getCapacity() {
        return this.ctx.getAmount() * this.capacity;
    }
}

