/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import com.diamssword.greenresurgence.items.equipment.EquipmentUpgradeItem;
import com.diamssword.greenresurgence.systems.equipement.AdvEquipmentSlot;
import com.diamssword.greenresurgence.systems.equipement.EquipmentUpgrade;
import com.diamssword.greenresurgence.systems.equipement.Equipments;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import com.diamssword.greenresurgence.systems.equipement.IUpgradableEquipment;
import com.diamssword.greenresurgence.utils.Utils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3468;
import org.jetbrains.annotations.Nullable;

public class StackBasedEquipment
implements IUpgradableEquipment {
    private final String subcategory;
    private final String category;
    private final Map<String, class_1799> content = new HashMap<String, class_1799>();
    private String skin;
    public final class_1799 stack;
    private final IEquipmentDef equipment;

    public StackBasedEquipment(String category, String subcategory, class_1799 stack) {
        this.category = category;
        this.subcategory = subcategory;
        this.stack = stack;
        this.equipment = Equipments.getEquipment(category, subcategory).get();
        this.fromNBT(stack.method_7948());
    }

    public StackBasedEquipment(IEquipmentDef def, class_1799 stack) {
        this.category = def.getEquipmentType();
        this.subcategory = def.getEquipmentSubtype();
        this.stack = stack;
        this.equipment = def;
        this.fromNBT(stack.method_7948());
    }

    protected void fromNBT(class_2487 tag) {
        this.content.clear();
        if (tag.method_10545("upgrades")) {
            class_2487 ut = tag.method_10562("upgrades");
            for (String k : ut.method_10541()) {
                class_2487 st = ut.method_10562(k);
                this.content.put(k, class_1799.method_7915((class_2487)st));
            }
        }
        if (tag.method_10545("skin")) {
            this.skin = tag.method_10558("skin");
        }
    }

    public class_1799 getUpgradeItem(String slot) {
        return this.content.getOrDefault(slot, class_1799.field_8037);
    }

    public void setUpgrade(class_1799 upgradeItem) {
        class_1792 class_17922 = upgradeItem.method_7909();
        if (class_17922 instanceof EquipmentUpgradeItem) {
            EquipmentUpgradeItem up = (EquipmentUpgradeItem)class_17922;
            if (this.equipment != null && up.canBeApplied(this.equipment, upgradeItem)) {
                this.content.put(up.slot(this.equipment), upgradeItem);
                if (up.slot(this.equipment).equals("skin")) {
                    this.skin = upgradeItem.method_7948().method_10558("skin");
                }
            }
        }
    }

    @Override
    public IEquipmentDef getEquipment() {
        return this.equipment;
    }

    public void setUpgrade(class_1799 upgradeItem, String slot) {
        if (upgradeItem.method_7960()) {
            this.clearUpgrade(slot);
        } else {
            this.setUpgrade(upgradeItem);
        }
    }

    public boolean isMinimalUpgradesSet() {
        for (String requiredSlot : this.equipment.getRequiredSlots()) {
            if (this.content.containsKey(requiredSlot)) continue;
            return false;
        }
        return true;
    }

    public void clearUpgrade(String slot) {
        this.content.remove(slot);
        if (slot.equals("skin")) {
            this.skin = "";
        }
    }

    public void save() {
        class_2487 nbt = this.stack.method_7948();
        class_2487 ups = new class_2487();
        this.content.forEach((k, v) -> ups.method_10566(k, (class_2520)v.method_7953(new class_2487())));
        nbt.method_10566("upgrades", (class_2520)ups);
        if (this.skin != null) {
            nbt.method_10582("skin", this.skin);
        }
    }

    @Override
    public String getEquipmentType() {
        return this.category;
    }

    @Override
    public String getEquipmentSubtype() {
        return this.subcategory;
    }

    @Override
    public String getSkin() {
        return this.skin;
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(AdvEquipmentSlot slot, @Nullable class_1657 player) {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.content.keySet().forEach(arg_0 -> this.lambda$getAttributeModifiers$1(slot, player, (Multimap)map, arg_0));
        return map;
    }

    protected Optional<EquipmentUpgradeItem> getAsEquipment(String slot) {
        class_1792 class_17922 = this.getUpgradeItem(slot).method_7909();
        if (class_17922 instanceof EquipmentUpgradeItem) {
            EquipmentUpgradeItem up = (EquipmentUpgradeItem)class_17922;
            return Optional.of(up);
        }
        return Optional.empty();
    }

    @Override
    public void onInteraction(class_1657 wearer, AdvEquipmentSlot slot, EquipmentUpgrade.InteractType interaction, class_239 context) {
        this.content.keySet().forEach(v -> {
            Optional<EquipmentUpgradeItem> eq = this.getAsEquipment((String)v);
            eq.ifPresent(equipmentUpgradeItem -> equipmentUpgradeItem.onInteraction(wearer, slot, interaction, context));
        });
    }

    public boolean onToolDamage(class_1309 owner, AdvEquipmentSlot slot) {
        if (this.content.isEmpty()) {
            return true;
        }
        Stream<String> keys = this.content.keySet().stream().filter(v -> this.getAsEquipment((String)v).map(EquipmentUpgradeItem::method_7846).orElse(false));
        String picked = Utils.selectRandomWeighted(keys.toList(), k -> this.getAsEquipment((String)k).map(EquipmentUpgradeItem::damageWheight).orElse(Float.valueOf(0.0f)));
        int dura = this.content.get(picked).method_7919() + 1;
        if (dura >= this.getAsEquipment(picked).get().maxDurability()) {
            if (owner instanceof class_1657) {
                ((class_1657)owner).method_7259(class_3468.field_15383.method_14956((Object)this.getAsEquipment(picked).get()));
            }
            this.content.remove(picked);
            if (this.content.isEmpty()) {
                return true;
            }
            class_1304 vsl = slot.getParent();
            if (vsl != null) {
                owner.method_20235(vsl);
            }
        } else {
            this.content.get(picked).method_7974(dura);
        }
        return false;
    }

    @Override
    public void onTick(class_1297 parent) {
        this.content.forEach((k, v) -> this.getAsEquipment((String)k).ifPresent(v1 -> v1.onTick(v, parent)));
    }

    public float getDurabilityProgress() {
        List<String> ls = this.content.keySet().stream().filter(v -> this.getAsEquipment((String)v).map(EquipmentUpgradeItem::method_7846).orElse(false)).toList();
        int act = 0;
        int max = 0;
        for (String k : ls) {
            max += this.getAsEquipment(k).get().maxDurability();
            act += this.content.get(k).method_7919();
        }
        if (max == 0) {
            return 1.0f;
        }
        return 1.0f - (float)act / (float)max;
    }

    private /* synthetic */ void lambda$getAttributeModifiers$1(AdvEquipmentSlot slot, class_1657 player, Multimap map, String v) {
        Multimap mod;
        Optional<EquipmentUpgradeItem> eq = this.getAsEquipment(v);
        if (eq.isPresent() && (mod = eq.get().getAttributeModifiers(slot, player)) != null) {
            map.putAll(mod);
        }
    }
}

