/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.faction.perimeter.components;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import team.reborn.energy.api.EnergyStorage;

public class TerrainEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public long amount = 0L;
    private long capacity = 0L;
    private final List<Long> poses = new ArrayList<Long>();

    public void addCapacity(int amount) {
        this.capacity = Math.max(0L, this.capacity + (long)amount);
        if (this.amount > this.capacity) {
            this.amount = this.capacity;
        }
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min(maxAmount, this.capacity - this.amount);
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.amount += inserted;
            return inserted;
        }
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min(maxAmount, this.amount);
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.amount -= extracted;
            return extracted;
        }
        return 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void toNBT(class_2487 tag) {
        tag.method_10544("amount", this.amount);
        tag.method_10544("capacity", this.capacity);
    }

    public void fromNBT(class_2487 tag) {
        this.capacity = tag.method_10537("capacity");
        this.amount = tag.method_10537("amount");
    }
}

