/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.lootables;

import com.diamssword.characters.api.ComponentManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class Lootable {
    private final Map<class_2960, class_2960> tables = new HashMap<class_2960, class_2960>();
    private final Map<class_2960, List<class_3545<String, Integer>>> statRequirement = new HashMap<class_2960, List<class_3545<String, Integer>>>();
    private final class_2248 block;
    private final class_2248 empty;
    private class_2248 connected = null;

    public Lootable(class_2960 block, class_2960 empty) throws Exception {
        class_2248 b = (class_2248)class_7923.field_41175.method_10223(block);
        class_2248 b1 = (class_2248)class_7923.field_41175.method_10223(empty);
        if (b == null || b == class_2246.field_10124) {
            throw new Exception();
        }
        this.block = b;
        if (b1 == null) {
            b1 = class_2246.field_10124;
        }
        this.empty = b1;
    }

    public Lootable(class_2248 block, class_2248 empty) {
        this.block = block;
        this.empty = empty;
    }

    public Lootable setConnected(class_2960 block) {
        this.connected = (class_2248)class_7923.field_41175.method_10223(block);
        return this;
    }

    public class_2248 getConnected() {
        return this.connected;
    }

    public boolean asTool(class_2960 id) {
        return this.tables.containsKey(id);
    }

    public class_2248 getEmptyBlock() {
        return this.empty;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public class_2960 getLootForTool(class_2960 tool) {
        return this.tables.get(tool);
    }

    public Lootable addTool(class_2960 tool, class_2960 lootable) {
        this.tables.put(tool, lootable);
        return this;
    }

    public boolean playerMeetRequirement(class_2960 tool, class_1657 player) {
        List<class_3545<String, Integer>> req = this.statRequirement.get(tool);
        if (req != null) {
            for (class_3545<String, Integer> v : req) {
                if ((Integer)v.method_15441() > ComponentManager.getPlayerDatas((class_1657)player).getStats().getPalier((String)v.method_15442())) continue;
                return true;
            }
            return req.isEmpty();
        }
        return true;
    }

    public Lootable addRequirement(class_2960 tool, String classe, int min_level) {
        if (!this.statRequirement.containsKey(tool)) {
            this.statRequirement.put(tool, new ArrayList());
        }
        this.statRequirement.get(tool).add((class_3545<String, Integer>)new class_3545((Object)classe, (Object)min_level));
        return this;
    }

    public class_2487 toNBT() {
        class_2487 comp = new class_2487();
        comp.method_10582("block", class_7923.field_41175.method_10221((Object)this.block).toString());
        comp.method_10582("empty", class_7923.field_41175.method_10221((Object)this.empty).toString());
        class_2487 ls = new class_2487();
        this.tables.forEach((v, t) -> ls.method_10582(v.toString(), t.toString()));
        comp.method_10566("tools", (class_2520)ls);
        return comp;
    }

    public static Lootable fromNBT(class_2487 comp) throws Exception {
        class_2960 b = new class_2960(comp.method_10558("block"));
        class_2960 b1 = new class_2960(comp.method_10558("empty"));
        Lootable res = new Lootable(b, b1);
        class_2487 ls = comp.method_10562("tools");
        ls.method_10541().forEach(k -> res.addTool(new class_2960(k), new class_2960(ls.method_10558(k))));
        return res;
    }
}

