/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SkinConverterUtil {
    public static void main(String[] args) {
        SkinConverterUtil.readFolder(new File("./skin_conf_gen/steves"));
    }

    private static BufferedImage holdClip(BufferedImage in) {
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), in.getType());
        Graphics g = out.getGraphics();
        g.drawImage(in, 0, 0, null);
        g.dispose();
        return out;
    }

    private static void readFolder(File path) {
        for (File file : path.listFiles()) {
            if (file.isDirectory()) {
                SkinConverterUtil.readFolder(file);
                continue;
            }
            try {
                System.out.println("converting " + String.valueOf(file));
                BufferedImage img = ImageIO.read(file);
                Graphics2D g = img.createGraphics();
                BufferedImage im1 = SkinConverterUtil.holdClip(img.getSubimage(96, 40, 8, 24));
                BufferedImage im2 = SkinConverterUtil.holdClip(img.getSubimage(105, 40, 8, 24));
                BufferedImage im3 = SkinConverterUtil.holdClip(img.getSubimage(96, 32, 7, 8));
                BufferedImage im4 = SkinConverterUtil.holdClip(img.getSubimage(73, 104, 22, 24));
                BufferedImage im5 = SkinConverterUtil.holdClip(img.getSubimage(73, 96, 7, 8));
                BufferedImage im6 = SkinConverterUtil.holdClip(img.getSubimage(81, 96, 7, 8));
                BufferedImage im7 = SkinConverterUtil.holdClip(img.getSubimage(96, 72, 8, 24));
                BufferedImage im8 = SkinConverterUtil.holdClip(img.getSubimage(105, 72, 8, 24));
                BufferedImage im9 = SkinConverterUtil.holdClip(img.getSubimage(96, 64, 7, 8));
                BufferedImage im10 = SkinConverterUtil.holdClip(img.getSubimage(105, 104, 22, 24));
                BufferedImage im11 = SkinConverterUtil.holdClip(img.getSubimage(105, 96, 7, 8));
                BufferedImage im12 = SkinConverterUtil.holdClip(img.getSubimage(113, 96, 7, 8));
                g.setBackground(new Color(0, 0, 0, 0));
                g.clearRect(95, 40, 17, 24);
                g.clearRect(95, 32, 9, 8);
                g.clearRect(72, 104, 24, 24);
                g.clearRect(72, 96, 16, 8);
                g.clearRect(95, 72, 17, 24);
                g.clearRect(95, 64, 9, 8);
                g.clearRect(104, 104, 24, 24);
                g.clearRect(104, 96, 16, 8);
                g.drawImage((Image)im1, 95, 40, null);
                g.drawImage((Image)im2, 103, 40, null);
                g.drawImage((Image)im3, 95, 32, null);
                g.drawImage((Image)im4, 72, 104, null);
                g.drawImage((Image)im5, 72, 96, null);
                g.drawImage((Image)im6, 79, 96, null);
                g.drawImage((Image)im7, 95, 72, null);
                g.drawImage((Image)im8, 103, 72, null);
                g.drawImage((Image)im9, 95, 64, null);
                g.drawImage((Image)im10, 104, 104, null);
                g.drawImage((Image)im11, 104, 96, null);
                g.drawImage((Image)im12, 112, 96, null);
                g.dispose();
                ImageIO.write((RenderedImage)img, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

