/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.containers;

import com.diamssword.greenresurgence.containers.Containers;
import com.diamssword.greenresurgence.containers.MultiInvScreenHandler;
import com.diamssword.greenresurgence.containers.OffsetInventory;
import com.diamssword.greenresurgence.containers.grids.GridContainer;
import com.diamssword.greenresurgence.containers.grids.GridContainerSyncer;
import com.diamssword.greenresurgence.containers.grids.IGridContainer;
import com.diamssword.greenresurgence.systems.equipement.Equipments;
import com.diamssword.greenresurgence.systems.equipement.IEquipementItem;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentBlueprint;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentUpgrade;
import io.wispforest.owo.client.screens.SyncedProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3917;

public class EquipmentScreenHandler
extends MultiInvScreenHandler {
    public Runnable onClosed;
    private IEquipmentDef equipment;
    private class_1799 toolStack;
    private SyncedProperty<EquipmentSync> equipmentProp;
    private Consumer<IEquipmentDef> equipmentListener;

    public EquipmentScreenHandler(int syncId, class_1661 playerInventory) {
        super(syncId, playerInventory);
        this.equipmentProp = this.createProperty(EquipmentSync.class, new EquipmentSync("", ""));
        this.onReady((MultiInvScreenHandler v) -> {
            if (this.equipment != null) {
                this.equipmentListener.accept(this.equipment);
            }
        });
        this.equipmentProp.observe(v -> {
            if (!v.subtype.isEmpty() && !v.type.isEmpty()) {
                this.equipment = Equipments.getEquipment(v.type, v.subtype).orElse(null);
                if (this.isReady()) {
                    this.equipmentListener.accept(this.equipment);
                }
            }
        });
    }

    public void onEquipmentReady(Consumer<IEquipmentDef> listener) {
        this.equipmentListener = listener;
    }

    public EquipmentScreenHandler(int syncId, class_1657 player, class_1277 tool, class_1277 upgrades) {
        super(syncId, player, new EquipmentGrid((class_1263)tool));
        this.toolStack = tool.method_5438(0);
        this.equipmentProp = this.createProperty(EquipmentSync.class, new EquipmentSync("", ""));
        IEquipmentDef eq = this.getEquipment();
        if (eq != null) {
            this.equipmentProp.set((Object)new EquipmentSync(eq.getEquipmentType(), eq.getEquipmentSubtype()));
        }
        this.recreateSlots(upgrades);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.onClosed != null) {
            this.onClosed.run();
        }
    }

    public IEquipmentDef getEquipment() {
        if (this.equipment == null && this.toolStack != null) {
            class_1792 class_17922 = this.toolStack.method_7909();
            if (class_17922 instanceof IEquipmentBlueprint) {
                IEquipmentBlueprint bp = (IEquipmentBlueprint)class_17922;
                this.equipment = bp.getEquipment();
            } else {
                class_17922 = this.toolStack.method_7909();
                if (class_17922 instanceof IEquipementItem) {
                    IEquipementItem bp = (IEquipementItem)class_17922;
                    this.equipment = bp.getEquipment(this.toolStack).getEquipment();
                }
            }
        }
        return this.equipment;
    }

    protected void recreateSlots(class_1277 inv) {
        ArrayList<IGridContainer> list = new ArrayList<IGridContainer>();
        IEquipmentDef eq = this.getEquipment();
        if (eq != null) {
            int i = 0;
            for (String slot : eq.getSlots()) {
                OffsetInventory off = new OffsetInventory((class_1263)inv, i, 1);
                list.add(new UpgradeGrid(slot, eq, off, 1, 1));
                ++i;
            }
        }
        ArrayList<IGridContainer> ls = new ArrayList<IGridContainer>(List.of(this.inventories));
        ls.addAll(list);
        this.inventories = ls.toArray(new IGridContainer[0]);
        list.forEach(this::addSlotsFor);
        this.props.set((Object)new GridContainerSyncer(this.getPos(), this.inventories));
    }

    @Override
    public class_3917<? extends MultiInvScreenHandler> type() {
        return Containers.EQUIPMENT_TINKERER;
    }

    public record EquipmentSync(String type, String subtype) {
    }

    public static class EquipmentGrid
    extends GridContainer {
        public EquipmentGrid(class_1263 inv) {
            super("tool_slot", inv, 1, 1);
        }

        @Override
        public class_1735 createSlotFor(int index, int x, int y) {
            return new EquipmentSlot(this.getInventory(), index, x, y);
        }
    }

    public static class UpgradeGrid
    extends GridContainer {
        public final IEquipmentDef equipment;
        private final String slot;

        public UpgradeGrid(String slot, IEquipmentDef equipment, class_1263 inv, int width, int height) {
            super("equipment_" + slot, inv, width, height);
            this.equipment = equipment;
            this.slot = slot;
        }

        @Override
        public class_1735 createSlotFor(int index, int x, int y) {
            return new UpgradeSlot(this.equipment, this.slot, this.getInventory(), index, x, y);
        }
    }

    public static class UpgradeSlot
    extends class_1735 {
        public final IEquipmentDef equipment;
        public final String slot;

        public UpgradeSlot(IEquipmentDef equipment, String slot, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.equipment = equipment;
            this.slot = slot;
        }

        public boolean method_7680(class_1799 stack) {
            IEquipmentUpgrade up;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof IEquipmentUpgrade && (up = (IEquipmentUpgrade)class_17922).slot(this.equipment).equals(this.slot)) {
                return up.canBeApplied(this.equipment, stack);
            }
            return false;
        }

        public int method_7675() {
            return 1;
        }

        public int method_7676(class_1799 stack) {
            return 1;
        }
    }

    public static class EquipmentSlot
    extends class_1735 {
        public EquipmentSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_7909() instanceof IEquipmentBlueprint || stack.method_7909() instanceof IEquipementItem;
        }

        public int method_7675() {
            return 1;
        }

        public int method_7676(class_1799 stack) {
            return 1;
        }
    }
}

