/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.datagen;

import com.diamssword.greenresurgence.genericBlocks.GenericBlockSet;
import com.diamssword.greenresurgence.genericBlocks.GenericBlocks;
import com.diamssword.greenresurgence.materials.MaterialSet;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_2960;

public class LangGenerator
extends FabricLanguageProvider {
    private final Path existingFilePath;
    private final Path existingStatsPath;
    public static Map<class_2960, String> auto_name = new HashMap<class_2960, String>();

    public LangGenerator(FabricDataOutput dataGenerator, String code) {
        super(dataGenerator, code);
        this.existingFilePath = LangGenerator.getDevPath("lang/_" + code + ".json");
        this.existingStatsPath = LangGenerator.getDevPath("lang/stats_" + code + ".json");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        try {
            for (GenericBlockSet set : GenericBlocks.sets) {
                set.langGenerator(translationBuilder);
            }
            MaterialSet.registerLangs(translationBuilder);
            translationBuilder.add("materials.tier.1", "Tier I");
            translationBuilder.add("materials.tier.2", "Tier II");
            translationBuilder.add("materials.tier.3", "Tier III");
            translationBuilder.add("materials.tier.4", "Tier IV");
            translationBuilder.add("materials.tier.5", "Tier V");
            try {
                translationBuilder.add(this.existingFilePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                translationBuilder.add(this.existingStatsPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    private void autoLocalize(FabricLanguageProvider.TranslationBuilder builder, class_2960 id, String name) {
        int i = name.lastIndexOf("/");
        if (i > 0) {
            name = name.substring(i + 1);
        }
        builder.add("item." + id.method_12836() + "." + id.method_12832().replaceAll("/", "."), LangGenerator.capitalizeString(name.replaceAll("_", " ")));
    }

    public static String autoLocalizeString(String name) {
        int i = name.lastIndexOf("/");
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return LangGenerator.capitalizeString(name.replaceAll("_", " "));
    }

    public static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static Path getDevPath(String path) {
        return Paths.get(Paths.get(System.getProperty("user.dir"), new String[0]).getParent().getParent().toString(), "src/main/devResources/" + path);
    }
}

