/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.dynamicLight;

import com.diamssword.greenresurgence.dynamicLight.CreateDynLightSource;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@Environment(value=EnvType.CLIENT)
public class ConeDynLightSource
extends CreateDynLightSource {
    private static final int ANGLE = 60;
    private static final int RANGE = 16;
    protected final class_2350 localDirection;
    private class_243 direction;

    public ConeDynLightSource(int id, AbstractContraptionEntity entity, class_2338 localPos, int luminance, class_2350 localDirection) {
        super(id, entity, localPos, luminance);
        this.localDirection = localDirection;
        class_2382 vec = localDirection.method_10163();
        this.direction = new class_243((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260());
    }

    @Override
    public void syncPositionAndLuminance() {
        if (this.contraptionEntity.method_37908() == class_310.method_1551().field_1687) {
            int newLuminance;
            class_243 newPosition = this.contraptionEntity.toGlobalVector(VecHelper.getCenterOf((class_2382)this.localPos), 1.0f);
            this.setPosition(newPosition);
            class_243 dirVec = class_243.method_24954((class_2382)this.localDirection.method_10163());
            this.direction = this.contraptionEntity.applyRotation(dirVec, 1.0f);
            class_3499.class_3501 blockInfo = (class_3499.class_3501)this.contraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && (newLuminance = blockInfo.comp_1342().method_26213()) != this.luminance) {
                this.luminance = newLuminance;
            }
        }
    }

    @Override
    @NotNull
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        class_243 tip = new class_243(this.position.field_1352 + this.direction.field_1352 * 16.0, this.position.field_1351 + this.direction.field_1351 * 16.0, this.position.field_1350 + this.direction.field_1350 * 16.0);
        double radius = 16.0 * Math.tan(Math.toRadians(30.0));
        int minX = (int)(Math.min(this.position.field_1352, tip.field_1352) - radius);
        int minY = (int)(Math.min(this.position.field_1351, tip.field_1351) - radius);
        int minZ = (int)(Math.min(this.position.field_1350, tip.field_1350) - radius);
        int maxX = (int)(Math.max(this.position.field_1352, tip.field_1352) + radius);
        int maxY = (int)(Math.max(this.position.field_1351, tip.field_1351) + radius);
        int maxZ = (int)(Math.max(this.position.field_1350, tip.field_1350) + radius);
        return new DynamicLightBehavior.BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public @Range(from=0L, to=15L) double lightAtPos(class_2338 pos, double falloffRatio) {
        double cutoff;
        class_243 sourcePos = this.position.method_1031(-this.direction.field_1352 * 2.0, -this.direction.field_1351 * 2.0, -this.direction.field_1350 * 2.0);
        class_243 facingDir = this.direction;
        double maxBrightness = this.luminance;
        class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_243 toTarget = new class_243(targetPos.field_1352 - sourcePos.field_1352, targetPos.field_1351 - sourcePos.field_1351, targetPos.field_1350 - sourcePos.field_1350);
        double distance = Math.sqrt(toTarget.field_1352 * toTarget.field_1352 + toTarget.field_1351 * toTarget.field_1351 + toTarget.field_1350 * toTarget.field_1350);
        if (distance < 1.0E-6 || distance > 16.0) {
            return 0.0;
        }
        class_243 dirToTarget = new class_243(toTarget.field_1352 / distance, toTarget.field_1351 / distance, toTarget.field_1350 / distance);
        double alignment = facingDir.field_1352 * dirToTarget.field_1352 + facingDir.field_1351 * dirToTarget.field_1351 + facingDir.field_1350 * dirToTarget.field_1350;
        if ((alignment = class_3532.method_15350((double)alignment, (double)-1.0, (double)1.0)) < (cutoff = Math.cos(Math.toRadians(30.0)))) {
            return 0.0;
        }
        double dirFactor = (alignment - cutoff) / (1.0 - cutoff);
        dirFactor = class_3532.method_15350((double)dirFactor, (double)0.0, (double)1.0);
        double distFactor = 1.0 - distance / 16.0;
        distFactor = class_3532.method_15350((double)distFactor, (double)0.0, (double)1.0);
        double lightLevel = maxBrightness * dirFactor * distFactor;
        return class_3532.method_15350((double)lightLevel, (double)0.0, (double)maxBrightness);
    }
}

