/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.dynamicLight;

import com.diamssword.greenresurgence.dynamicLight.CreateDynLightSourceHolder;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;

@Environment(value=EnvType.CLIENT)
public class ContraptionEntityEventHandler {
    private static final List<AbstractContraptionEntity> scheduledToAddContraptionEntities = new ArrayList<AbstractContraptionEntity>();
    private static boolean lastDynamicLightEnabled = true;
    private static final List<AbstractContraptionEntity> contraptionEntities = new ArrayList<AbstractContraptionEntity>();

    public static void onContraptionEntityJoin(AbstractContraptionEntity contraptionEntity) {
        contraptionEntities.add(contraptionEntity);
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption != null) {
            ContraptionEntityEventHandler.addLightSourcesOfContraption(contraption);
            return;
        }
        scheduledToAddContraptionEntities.add(contraptionEntity);
    }

    public static void onContraptionEntityLeave(AbstractContraptionEntity contraptionEntity) {
        contraptionEntities.remove(contraptionEntity);
        CreateDynLightSourceHolder.INSTANCE.removeAll(contraptionEntity);
    }

    private static void addLightSourcesOfContraption(Contraption contraption) {
        Map blocks = contraption.getBlocks();
        blocks.forEach((pos, blockInfo) -> {
            if (blockInfo.comp_1342().method_26213() > 0) {
                CreateDynLightSourceHolder.INSTANCE.getOrCreate(contraption.entity, blockInfo.comp_1341(), blockInfo.comp_1342());
            }
        });
    }

    public static void onTick(class_1937 level) {
        ArrayList<AbstractContraptionEntity> toRemove = new ArrayList<AbstractContraptionEntity>();
        for (AbstractContraptionEntity entity : scheduledToAddContraptionEntities) {
            Contraption contraption = entity.getContraption();
            if (contraption == null) continue;
            ContraptionEntityEventHandler.addLightSourcesOfContraption(contraption);
            toRemove.add(entity);
        }
        scheduledToAddContraptionEntities.removeAll(toRemove);
        CreateDynLightSourceHolder.INSTANCE.update();
    }
}

