/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.dynamicLight;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@Environment(value=EnvType.CLIENT)
public class CreateDynLightSource
implements DynamicLightBehavior {
    protected final AbstractContraptionEntity contraptionEntity;
    protected final class_2338 localPos;
    protected class_243 position;
    protected int luminance;
    private final int id;
    private long lambDynLightsLastUpdate;
    protected class_2338 blockPos;

    public CreateDynLightSource(int id, AbstractContraptionEntity entity, class_2338 localPos, int luminance) {
        this.contraptionEntity = entity;
        this.id = id;
        this.luminance = luminance;
        this.localPos = localPos;
        class_243 worldPos = entity.toGlobalVector(VecHelper.getCenterOf((class_2382)localPos), 1.0f);
        this.setPosition(worldPos);
    }

    protected void setPosition(class_243 position) {
        this.position = position;
        int x = class_3532.method_15357((double)position.field_1352);
        int y = class_3532.method_15357((double)position.field_1351);
        int z = class_3532.method_15357((double)position.field_1350);
        this.blockPos = new class_2338(x, y, z);
    }

    public class_2338 blockPosition() {
        return this.blockPos;
    }

    public int getLuminance() {
        return this.luminance;
    }

    public void syncPositionAndLuminance() {
        if (this.contraptionEntity.method_37908() == class_310.method_1551().field_1687) {
            int newLuminance;
            class_243 newPosition = this.contraptionEntity.toGlobalVector(VecHelper.getCenterOf((class_2382)this.localPos), 1.0f);
            this.setPosition(newPosition);
            class_3499.class_3501 blockInfo = (class_3499.class_3501)this.contraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && (newLuminance = blockInfo.comp_1342().method_26213()) != this.luminance) {
                this.luminance = newLuminance;
            }
        }
    }

    public boolean shouldUpdateDynamicLight() {
        int delay = 0;
        if (delay > 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambDynLightsLastUpdate + (long)delay) {
                return false;
            }
            this.lambDynLightsLastUpdate = currentTime;
        }
        return true;
    }

    public boolean update() {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        this.syncPositionAndLuminance();
        return false;
    }

    public @Range(from=0L, to=15L) double lightAtPos(class_2338 pos, double falloffRatio) {
        double dx = (double)pos.method_10263() - this.position.field_1352;
        double dy = (double)pos.method_10264() - this.position.field_1351;
        double dz = (double)pos.method_10260() - this.position.field_1350;
        int lum = Math.min(15, Math.max(0, this.getLuminance()));
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        return Math.max((double)lum - Math.sqrt(distanceSquared) * falloffRatio, 0.0);
    }

    @NotNull
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        return new DynamicLightBehavior.BoundingBox(this.blockPos.method_10263(), this.blockPos.method_10264(), this.blockPos.method_10260(), this.blockPos.method_10263() + 1, this.blockPos.method_10264() + 1, this.blockPos.method_10260() + 1);
    }

    public boolean hasChanged() {
        return this.shouldUpdateDynamicLight();
    }

    public boolean isRemoved() {
        return this.contraptionEntity.method_31481();
    }
}

