/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.dynamicLight;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.dynamicLight.ConeDynLightSource;
import com.diamssword.greenresurgence.dynamicLight.CreateDynLightSource;
import com.diamssword.greenresurgence.dynamicLight.DynamicLightsManager;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class CreateDynLightSourceHolder {
    public static final CreateDynLightSourceHolder INSTANCE = new CreateDynLightSourceHolder();
    public static final List<class_2960> coneLights = Arrays.asList(GreenResurgence.asRessource("diams_lamp_marine_big_black"), GreenResurgence.asRessource("diams_lamp_marine_big_copper"), GreenResurgence.asRessource("diams_lamp_marine_big_gold"), GreenResurgence.asRessource("diams_lamp_marine_big_metal"));
    AtomicInteger atomicInt = new AtomicInteger(0);
    Map<LightSourceKey, CreateDynLightSource> lightSources = new HashMap<LightSourceKey, CreateDynLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();

    private CreateDynLightSourceHolder() {
    }

    public CreateDynLightSource create(AbstractContraptionEntity entity, class_2338 blockPos, class_2680 state) {
        int id = this.atomicInt.incrementAndGet();
        class_2960 bid = class_7923.field_41175.method_10221((Object)state.method_26204());
        CreateDynLightSource lightSource = null;
        lightSource = coneLights.contains(bid) ? new ConeDynLightSource(id, entity, blockPos, state.method_26213(), this.getDir(state)) : new CreateDynLightSource(id, entity, blockPos, state.method_26213());
        this.lightSourcesLock.writeLock().lock();
        this.lightSources.put(new LightSourceKey(entity.method_5628(), blockPos), lightSource);
        this.lightSourcesLock.writeLock().unlock();
        DynamicLightsManager.INSTANCE.addLightSource(lightSource);
        return lightSource;
    }

    private class_2350 getDir(class_2680 state) {
        for (class_2769 property : state.method_28501()) {
            if (!(property instanceof class_2753)) continue;
            class_2753 dir = (class_2753)property;
            return ((class_2350)state.method_11654((class_2769)dir)).method_10153();
        }
        return class_2350.field_11036;
    }

    public void remove(int entityId, class_2338 blockPos) {
        this.lightSourcesLock.writeLock().lock();
        CreateDynLightSource lightSource = this.lightSources.remove(new LightSourceKey(entityId, blockPos));
        if (lightSource != null) {
            DynamicLightsManager.INSTANCE.removeLightSource(lightSource);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeAll(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption == null) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        for (class_2338 blockPos : contraptionEntity.getContraption().getBlocks().keySet()) {
            CreateDynLightSource lightSource = this.lightSources.remove(new LightSourceKey(contraptionEntity.method_5628(), blockPos));
            if (lightSource == null) continue;
            DynamicLightsManager.INSTANCE.removeLightSource(lightSource);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void update() {
        this.lightSourcesLock.writeLock().lock();
        this.lightSources.forEach((k, l) -> l.update());
        this.lightSourcesLock.writeLock().unlock();
    }

    public Optional<CreateDynLightSource> get(int entityId, class_2338 blockPos) {
        return this.get(new LightSourceKey(entityId, blockPos));
    }

    public CreateDynLightSource getOrCreate(AbstractContraptionEntity entity, class_2338 blockPos, class_2680 state) {
        return this.get(entity.method_5628(), blockPos).orElseGet(() -> this.create(entity, blockPos, state));
    }

    public Optional<CreateDynLightSource> get(LightSourceKey key) {
        this.lightSourcesLock.readLock().lock();
        CreateDynLightSource lightSource = this.lightSources.get(key);
        this.lightSourcesLock.readLock().unlock();
        return Optional.ofNullable(lightSource);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LightSourceKey {
        private final int entityId;
        private final class_2338 blockPos;

        public LightSourceKey(int entityId, class_2338 blockPos) {
            this.entityId = entityId;
            this.blockPos = blockPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightSourceKey that = (LightSourceKey)o;
            return this.entityId == that.entityId && Objects.equals(this.blockPos, that.blockPos);
        }

        public int hashCode() {
            return Objects.hash(this.entityId, this.blockPos.method_10063());
        }
    }
}

