/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.dynamicLight;

import dev.lambdaurora.lambdynlights.api.behavior.DynamicLightBehavior;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public class FlashlightLightBehavior
implements DynamicLightBehavior {
    private final class_1297 entity;
    private final float RADIUS = 8.0f;
    private final float DEPTH = 20.0f;
    private final float DISTANCE_DELTA = 3.0f;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevYaw;
    private float prevPitch;
    private Matrix3d rotationMatrix;
    private Matrix3d inverseRotationMatrix;

    public FlashlightLightBehavior(class_1297 entity) {
        this.entity = entity;
        this.computeMatrices();
    }

    public @Range(from=0L, to=15L) double lightAtPos(class_2338 pos, double falloffRatio) {
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        Vector3d coord = this.worldToEntitySpace(new Vector3d(x, y, z));
        double sdf = Math.min(8.0 * (0.5 - coord.y() / 20.0) - Math.sqrt(coord.x() * coord.x() + coord.z() * coord.z()), 10.0 - Math.abs(coord.y()));
        double distance = 10.0 - coord.y() - 3.0;
        double intensity = 20.0 / Math.pow(distance, 1.5);
        double light = intensity * 15.0;
        return FlashlightLightBehavior.clamp(FlashlightLightBehavior.smoothstep(sdf), 0.0, 1.0) * light;
    }

    public static double clamp(double value, double min, double max) {
        if (!(min < max)) {
            if (Double.isNaN(min)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(max)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(min, max) > 0) {
                throw new IllegalArgumentException(min + " > " + max);
            }
        }
        return Math.min(max, Math.max(value, min));
    }

    public static double smoothstep(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        return x * x * (3.0 - 2.0 * x);
    }

    @NotNull
    public DynamicLightBehavior.BoundingBox getBoundingBox() {
        double[] horizontalValues = new double[]{-8.0, 8.0};
        double[] yValues = new double[]{-Math.ceil(10.0), Math.floor(10.0)};
        ArrayList<Vector3d> vectors = new ArrayList<Vector3d>();
        for (double x : horizontalValues) {
            for (double y : yValues) {
                for (double z : horizontalValues) {
                    vectors.add(this.entityToWorldSpace(new Vector3d(x, y, z)));
                }
            }
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (Vector3d vector : vectors) {
            if (vector.x() < minX) {
                minX = vector.x();
            }
            if (vector.y() < minY) {
                minY = vector.y();
            }
            if (vector.z() < minZ) {
                minZ = vector.z();
            }
            if (vector.x() > maxX) {
                maxX = vector.x();
            }
            if (vector.y() > maxY) {
                maxY = vector.y();
            }
            if (!(vector.z() > maxZ)) continue;
            maxZ = vector.z();
        }
        return new DynamicLightBehavior.BoundingBox(class_3532.method_15357((double)minX), class_3532.method_15357((double)minY), class_3532.method_15357((double)minZ), class_3532.method_15384((double)maxX), class_3532.method_15384((double)maxY), class_3532.method_15384((double)maxZ));
    }

    public boolean hasChanged() {
        if (Math.abs(this.entity.method_23317() - this.prevX) >= 0.1 || Math.abs(this.entity.method_23318() - this.prevY) >= 0.1 || Math.abs(this.entity.method_23321() - this.prevZ) >= 0.1 || (double)Math.abs(this.entity.method_36454() - this.prevYaw) >= 0.1 || (double)Math.abs(this.entity.method_36455() - this.prevPitch) >= 0.1) {
            this.prevX = this.entity.method_23317();
            this.prevY = this.entity.method_23318();
            this.prevZ = this.entity.method_23321();
            this.prevYaw = this.entity.method_36454();
            this.prevPitch = this.entity.method_36455();
            this.computeMatrices();
            return true;
        }
        return false;
    }

    private void computeMatrices() {
        Matrix3d matrix = new Matrix3d();
        matrix.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.entity.method_36455()));
        matrix.rotate((Quaternionfc)class_7833.field_40717.rotation(1.5707964f));
        matrix.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(this.entity.method_36454()));
        matrix.rotate((Quaternionfc)class_7833.field_40716.rotation(1.5707964f));
        this.rotationMatrix = matrix;
        this.inverseRotationMatrix = matrix.invert(new Matrix3d());
    }

    private Vector3d worldToEntitySpace(Vector3d in) {
        in.sub(this.entity.method_23317(), this.entity.method_23320(), this.entity.method_23321());
        in.mul((Matrix3dc)this.rotationMatrix);
        in.y += 6.0;
        return in;
    }

    private Vector3d entityToWorldSpace(Vector3d in) {
        in.y -= 6.0;
        in.mul((Matrix3dc)this.inverseRotationMatrix);
        in.add(this.entity.method_23317(), this.entity.method_23320(), this.entity.method_23321());
        return in;
    }
}

