/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.genericBlocks;

import com.diamssword.greenresurgence.genericBlocks.GenericBlockSet;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;
import org.jetbrains.annotations.Nullable;

public class AllDirectionVine
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 DOWN = class_2429.field_11330;
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = (Map)class_2429.field_11329.entrySet().stream().collect(class_156.method_664());
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;
    private final GenericBlockSet.Transparency transparency;
    private final boolean noHitbox;
    private final float damage;

    public AllDirectionVine(class_4970.class_2251 settings, GenericBlockSet.GenericBlockProp props) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.FALSE)).method_11657((class_2769)DOWN, (Comparable)Boolean.FALSE)).method_11657((class_2769)NORTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)SOUTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)WEST, (Comparable)Boolean.FALSE)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.noHitbox = !props.solid;
        this.shapesByState = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), AllDirectionVine::getShapeForState)));
        this.transparency = props.transparency;
        this.damage = props.damage;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (this.damage > 0.0f) {
            entity.method_5643(world.method_48963().method_48826(), this.damage);
        }
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DOWN_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByState.get(state);
    }

    public boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, (class_1922)world, pos));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (this.noHitbox) {
            return class_259.method_1073();
        }
        return super.method_9549(state, world, pos, context);
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        if (this.transparency == GenericBlockSet.Transparency.UNDEFINED || this.transparency == GenericBlockSet.Transparency.OPAQUE) {
            return super.method_9575(state, world, pos);
        }
        return 1.0f;
    }

    private boolean hasAdjacentBlocks(class_2680 state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(class_2680 state) {
        int i = 0;
        for (class_2746 booleanProperty : FACING_PROPERTIES.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean shouldHaveSide(class_1922 world, class_2338 pos, class_2350 side) {
        class_2338 blockPos = pos.method_10093(side);
        if (AllDirectionVine.shouldConnectTo(world, blockPos, side)) {
            return true;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2746 booleanProperty = FACING_PROPERTIES.get(side);
        class_2680 blockState = world.method_8320(pos.method_10084());
        return blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
    }

    public static boolean shouldConnectTo(class_1922 world, class_2338 pos, class_2350 direction) {
        return class_5778.method_33358((class_1922)world, (class_2350)direction, (class_2338)pos, (class_2680)world.method_8320(pos));
    }

    private class_2680 getPlacementShape(class_2680 state, class_1922 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        class_2680 blockState = null;
        for (class_2350 direction : class_2350.values()) {
            class_2746 booleanProperty = AllDirectionVine.getFacingProperty(direction);
            if (!((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue()) continue;
            boolean bl = this.shouldHaveSide(world, pos, direction);
            if (!bl) {
                if (blockState == null) {
                    blockState = world.method_8320(blockPos);
                }
                bl = blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(bl));
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2680 blockState;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return !this.hasAdjacentBlocks(blockState = this.getPlacementShape(state, (class_1922)world, pos)) ? class_2246.field_10124.method_9564() : blockState;
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (context.method_8041().method_7909() == this.method_8389()) {
            return this.getAdjacentBlockCount(blockState) < FACING_PROPERTIES.size();
        }
        return super.method_9616(state, context);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        boolean bl = blockState.method_27852((class_2248)this);
        class_2680 blockState2 = bl ? blockState : this.method_9564();
        for (class_2350 direction : ctx.method_7718()) {
            boolean bl2;
            class_2746 booleanProperty = AllDirectionVine.getFacingProperty(direction);
            boolean bl3 = bl2 = bl && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            if (bl2 || !this.shouldHaveSide((class_1922)ctx.method_8045(), ctx.method_8037(), direction)) continue;
            return (class_2680)blockState2.method_11657((class_2769)booleanProperty, (Comparable)Boolean.TRUE);
        }
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return bl ? (class_2680)blockState2.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910)) : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    public static class_2746 getFacingProperty(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }
}

