/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui;

import com.diamssword.greenresurgence.containers.AbstractMultiInvScreenHandler;
import com.diamssword.greenresurgence.containers.grids.IGridContainer;
import com.diamssword.greenresurgence.gui.RessourceGuiHelper;
import com.diamssword.greenresurgence.gui.components.InventoryComponent;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.util.UIErrorToast;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class MultiInvHandledScreen<T extends AbstractMultiInvScreenHandler<?>, R extends ParentComponent>
extends class_437
implements class_3936<T> {
    protected int backgroundWidth = 176;
    protected int backgroundHeight = 166;
    protected final T handler;
    @Nullable
    protected class_1735 focusedSlot;
    @Nullable
    protected class_1735 touchDragSlotStart;
    @Nullable
    private class_1735 touchDropOriginSlot;
    @Nullable
    private class_1735 touchHoveredSlot;
    @Nullable
    private class_1735 lastClickedSlot;
    protected int x;
    protected int y;
    protected boolean touchIsRightClickDrag;
    protected class_1799 touchDragStack = class_1799.field_8037;
    private int touchDropX;
    private int touchDropY;
    private long touchDropTime;
    private class_1799 touchDropReturningStack = class_1799.field_8037;
    private long touchDropTimer;
    protected final Set<class_1735> cursorDragSlots = Sets.newHashSet();
    protected boolean cursorDragging;
    protected int heldButtonType;
    private int heldButtonCode;
    private boolean cancelNextRelease;
    private int draggedStackRemainder;
    private long lastButtonClickTime;
    private int lastClickedButton;
    private boolean doubleClicking;
    private class_1799 quickMovingStack = class_1799.field_8037;
    protected final UIModel model;
    protected final Class<R> rootComponentClass;
    @Nullable
    protected final class_2960 modelId;
    protected OwoUIAdapter<R> uiAdapter = null;
    protected Map<String, InventoryComponent> invsComps = new HashMap<String, InventoryComponent>();
    protected boolean invalid = false;

    public MultiInvHandledScreen(T handler, Class<R> rootComponentClass, BaseUIModelScreen.DataSource source) {
        super((class_2561)class_2561.method_43470((String)""));
        class_2960 class_29602;
        this.handler = handler;
        this.cancelNextRelease = true;
        UIModel providedModel = source.get();
        if (providedModel == null) {
            source.reportError();
            this.invalid = true;
        }
        this.rootComponentClass = rootComponentClass;
        this.model = providedModel;
        if (source instanceof BaseUIModelScreen.DataSource.AssetDataSource) {
            BaseUIModelScreen.DataSource.AssetDataSource assetSource = (BaseUIModelScreen.DataSource.AssetDataSource)source;
            class_29602 = assetSource.assetPath();
        } else {
            class_29602 = null;
        }
        this.modelId = class_29602;
        this.handler.onReady(v -> {
            ParentComponent patt0$temp;
            if (this.uiAdapter != null && (patt0$temp = this.uiAdapter.rootComponent) instanceof BaseParentComponent) {
                BaseParentComponent r = (BaseParentComponent)patt0$temp;
                this.findInvComps(r);
            }
        });
    }

    protected MultiInvHandledScreen(T handler, Class<R> rootComponentClass, class_2960 modelId) {
        this(handler, rootComponentClass, BaseUIModelScreen.DataSource.asset((class_2960)modelId));
    }

    protected void method_25426() {
        this.invsComps.clear();
        this.x = (this.field_22789 - this.backgroundWidth) / 2;
        this.y = (this.field_22790 - this.backgroundHeight) / 2;
        if (this.invalid) {
            return;
        }
        if (this.uiAdapter != null) {
            this.uiAdapter.moveAndResize(0, 0, this.field_22789, this.field_22790);
            this.method_37063((class_364)this.uiAdapter);
            ParentComponent parentComponent = this.uiAdapter.rootComponent;
            if (parentComponent instanceof BaseParentComponent) {
                BaseParentComponent r = (BaseParentComponent)parentComponent;
                if (((AbstractMultiInvScreenHandler)((Object)this.handler)).isReady()) {
                    this.findInvComps(r);
                }
            }
        } else {
            try {
                this.uiAdapter = this.createAdapter();
                this.build(this.uiAdapter.rootComponent);
                this.uiAdapter.inflateAndMount();
                ParentComponent parentComponent = this.uiAdapter.rootComponent;
                if (parentComponent instanceof BaseParentComponent) {
                    BaseParentComponent r = (BaseParentComponent)parentComponent;
                    if (((AbstractMultiInvScreenHandler)((Object)this.handler)).isReady()) {
                        this.findInvComps(r);
                    }
                }
            }
            catch (Exception error) {
                Owo.LOGGER.warn("Could not initialize owo screen", (Throwable)error);
                UIErrorToast.report((Throwable)error);
                this.invalid = true;
            }
        }
    }

    protected void findInvComps(BaseParentComponent root) {
        root.children().forEach(c -> {
            if (c instanceof InventoryComponent) {
                InventoryComponent par = (InventoryComponent)c;
                this.invsComps.put(par.inventoryId, par);
                IGridContainer inv = ((AbstractMultiInvScreenHandler)((Object)((Object)this.handler))).getInventory(par.inventoryId);
                if (inv != null) {
                    par.setSize(inv.getWidth(), inv.getHeight());
                } else {
                    par.hidden(true);
                }
            } else if (c instanceof BaseParentComponent) {
                BaseParentComponent c1 = (BaseParentComponent)c;
                this.findInvComps(c1);
            }
        });
    }

    @Nullable
    protected <C extends Component> C component(Class<C> expectedClass, String id) {
        return (C)this.uiAdapter.rootComponent.childById(expectedClass, id);
    }

    @NotNull
    protected OwoUIAdapter<R> createAdapter() {
        return this.model.createAdapter(this.rootComponentClass, (class_437)this);
    }

    protected abstract void build(R var1);

    public Pair<Integer, Integer> getSlotPosition(class_1735 s, String inventory) {
        InventoryComponent comp = this.invsComps.get(inventory);
        if (comp != null) {
            boolean b = comp.getInventoryName() != null;
            return new Pair((Object)(s.field_7873 + comp.x() - this.x), (Object)(s.field_7872 + comp.y() - this.y + (b ? 10 : 1)));
        }
        return new Pair((Object)0, (Object)0);
    }

    protected void drawSlots(class_332 context, int mouseX, int mouseY, float delta) {
        for (String id : this.invsComps.keySet()) {
            List<class_1735> slots = ((AbstractMultiInvScreenHandler)((Object)this.handler)).getSlotForInventory(id);
            for (class_1735 slot : slots) {
                if (slot.method_7682()) {
                    this.drawSlot(context, slot, id);
                }
                if (!this.isPointOverSlot(slot, mouseX, mouseY) || !slot.method_7682()) continue;
                this.focusedSlot = slot;
                Pair<Integer, Integer> pos = this.getSlotPosition(slot, id);
                if (!this.focusedSlot.method_51306()) continue;
                MultiInvHandledScreen.drawSlotHighlight(context, (Integer)pos.getFirst(), (Integer)pos.getSecond(), 0);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.invalid) {
            this.method_25419();
            return;
        }
        OwoUIDrawContext context1 = OwoUIDrawContext.of((class_332)context);
        if (this.uiAdapter.enableInspector) {
            context1.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            int i = 0;
            for (String id : this.invsComps.keySet()) {
                List<class_1735> slots = ((AbstractMultiInvScreenHandler)((Object)this.handler)).getSlotForInventory(id);
                for (class_1735 slot : slots) {
                    if (!slot.method_7682()) continue;
                    Pair<Integer, Integer> pos = this.getSlotPosition(slot, id);
                    context1.drawText((class_2561)class_2561.method_43470((String)("H:" + i)), (float)(this.x + (Integer)pos.getFirst() + 15), (float)(this.y + (Integer)pos.getSecond() + 9), 0.5f, 38655, OwoUIDrawContext.TextAnchor.BOTTOM_RIGHT);
                    context1.drawText((class_2561)class_2561.method_43470((String)("I:" + slot.method_34266())), (float)(this.x + (Integer)pos.getFirst() + 15), (float)(this.y + (Integer)pos.getSecond() + 15), 0.5f, 5767423, OwoUIDrawContext.TextAnchor.BOTTOM_RIGHT);
                    ++i;
                }
            }
            context.method_51448().method_46416(0.0f, 0.0f, -500.0f);
        }
        int i = this.x;
        int j = this.y;
        this.drawBackground(context, delta, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)i, (float)j, 0.0f);
        this.focusedSlot = null;
        this.drawSlots(context, mouseX, mouseY, delta);
        this.drawForeground(context, mouseX, mouseY);
        class_1799 itemStack = this.touchDragStack.method_7960() ? this.handler.method_34255() : this.touchDragStack;
        class_1799 itemStack2 = itemStack;
        if (!itemStack.method_7960()) {
            int n = 8;
            int l = this.touchDragStack.method_7960() ? 8 : 16;
            String string = null;
            if (!this.touchDragStack.method_7960() && this.touchIsRightClickDrag) {
                itemStack = itemStack.method_46651(class_3532.method_15386((float)((float)itemStack.method_7947() / 2.0f)));
            } else if (this.cursorDragging && this.cursorDragSlots.size() > 1 && (itemStack = itemStack.method_46651(this.draggedStackRemainder)).method_7960()) {
                string = String.valueOf(class_124.field_1054) + "0";
            }
            this.drawItem(context, itemStack, mouseX - i - 8, mouseY - j - l, string);
        }
        if (!this.touchDropReturningStack.method_7960()) {
            float f = (float)(class_156.method_658() - this.touchDropTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.touchDropReturningStack = class_1799.field_8037;
            }
            int l = this.touchDropOriginSlot.field_7873 - this.touchDropX;
            int m = this.touchDropOriginSlot.field_7872 - this.touchDropY;
            int o = this.touchDropX + (int)((float)l * f);
            int p = this.touchDropY + (int)((float)m * f);
            this.drawItem(context, this.touchDropReturningStack, o, p, null);
        }
        context.method_51448().method_22909();
        RenderSystem.enableDepthTest();
        this.drawMouseoverTooltip(context, mouseX, mouseY);
    }

    public static void drawSlotHighlight(class_332 context, int x, int y, int z) {
        context.method_51740(class_1921.method_51785(), x, y, x + 16, y + 16, -2130706433, -2130706433, z);
    }

    protected void drawMouseoverTooltip(class_332 context, int x, int y) {
        if (this.handler.method_34255().method_7960() && this.focusedSlot != null && this.focusedSlot.method_7681()) {
            class_1799 itemStack = this.focusedSlot.method_7677();
            context.method_51437(this.field_22793, this.getTooltipFromItem(itemStack), itemStack.method_32347(), x, y);
        }
    }

    protected List<class_2561> getTooltipFromItem(class_1799 stack) {
        return MultiInvHandledScreen.method_25408((class_310)this.field_22787, (class_1799)stack);
    }

    private void drawItem(class_332 context, class_1799 stack, int x, int y, String amountText) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 232.0f);
        context.method_51427(stack, x, y);
        if (amountText != null) {
            context.method_51432(this.field_22793, stack, x, y - (this.touchDragStack.method_7960() ? 0 : 8), amountText);
        } else if (!stack.method_7960() && stack.method_7947() > 1) {
            RessourceGuiHelper.drawRessourceExtra(context, UniversalResource.fromItemOpti(stack), x, y, 0.0f, 0xFFFFFF);
        }
        context.method_51448().method_22909();
    }

    protected void drawForeground(class_332 context, int mouseX, int mouseY) {
    }

    protected abstract void drawBackground(class_332 var1, float var2, int var3, int var4);

    protected void drawSlot(class_332 context, class_1735 slot, String inventory) {
        Pair pair;
        Pair<Integer, Integer> pos = this.getSlotPosition(slot, inventory);
        class_1799 itemStack = slot.method_7677();
        boolean bl = false;
        boolean bl2 = slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && !this.touchIsRightClickDrag;
        class_1799 itemStack2 = this.handler.method_34255();
        String string = null;
        if (slot == this.touchDragSlotStart && !this.touchDragStack.method_7960() && this.touchIsRightClickDrag && !itemStack.method_7960()) {
            itemStack = itemStack.method_46651(itemStack.method_7947() / 2);
        } else if (this.cursorDragging && this.cursorDragSlots.contains(slot) && !itemStack2.method_7960()) {
            if (this.cursorDragSlots.size() == 1) {
                return;
            }
            if (class_1703.method_7592((class_1735)slot, (class_1799)itemStack2, (boolean)true) && this.handler.method_7615(slot)) {
                bl = true;
                int k = Math.min(itemStack2.method_7914(), slot.method_7676(itemStack2));
                int l = slot.method_7677().method_7960() ? 0 : slot.method_7677().method_7947();
                int m = class_1703.method_7617(this.cursorDragSlots, (int)this.heldButtonType, (class_1799)itemStack2) + l;
                if (m > k) {
                    m = k;
                    string = class_124.field_1054.toString() + k;
                }
                itemStack = itemStack2.method_46651(m);
            } else {
                this.cursorDragSlots.remove(slot);
                this.calculateOffset();
            }
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        if (itemStack.method_7960() && slot.method_7682() && (pair = slot.method_7679()) != null) {
            class_1058 sprite = (class_1058)this.field_22787.method_1549((class_2960)pair.getFirst()).apply((class_2960)pair.getSecond());
            context.method_25298(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), 0, 16, 16, sprite);
            bl2 = true;
        }
        if (!bl2) {
            if (bl) {
                context.method_25294(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), (Integer)pos.getFirst() + 16, (Integer)pos.getSecond() + 16, -2130706433);
            }
            context.method_51428(itemStack, ((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), (Integer)pos.getFirst() + (Integer)pos.getSecond() * this.backgroundWidth);
            if (string != null || itemStack.method_31578()) {
                context.method_51432(this.field_22793, itemStack, ((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue(), string);
            } else if (!itemStack.method_7960() && itemStack.method_7947() > 1) {
                RessourceGuiHelper.drawRessourceExtra(context, UniversalResource.fromItemOpti(itemStack), (Integer)pos.getFirst(), (Integer)pos.getSecond(), 0.0f, 0xFFFFFF);
            }
        }
        context.method_51448().method_22909();
    }

    protected void calculateOffset() {
        class_1799 itemStack = this.handler.method_34255();
        if (itemStack.method_7960() || !this.cursorDragging) {
            return;
        }
        if (this.heldButtonType == 2) {
            this.draggedStackRemainder = itemStack.method_7914();
            return;
        }
        this.draggedStackRemainder = itemStack.method_7947();
        for (class_1735 slot : this.cursorDragSlots) {
            class_1799 itemStack2 = slot.method_7677();
            int i = itemStack2.method_7960() ? 0 : itemStack2.method_7947();
            int j = Math.min(itemStack.method_7914(), slot.method_7676(itemStack));
            int k = Math.min(class_1703.method_7617(this.cursorDragSlots, (int)this.heldButtonType, (class_1799)itemStack) + i, j);
            this.draggedStackRemainder -= k - i;
        }
    }

    @Nullable
    protected class_1735 getSlotAt(double x, double y) {
        for (int i = 0; i < ((AbstractMultiInvScreenHandler)((Object)this.handler)).field_7761.size(); ++i) {
            class_1735 slot = (class_1735)((AbstractMultiInvScreenHandler)((Object)this.handler)).field_7761.get(i);
            if (!this.isPointOverSlot(slot, x, y) || !slot.method_7682()) continue;
            return slot;
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean bl = this.field_22787.field_1690.field_1871.method_1433(button) && this.field_22787.field_1761.method_2914();
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        long l = class_156.method_658();
        this.doubleClicking = this.lastClickedSlot == slot && l - this.lastButtonClickTime < 250L && this.lastClickedButton == button;
        this.cancelNextRelease = false;
        if (button == 0 || button == 1 || bl) {
            int i = this.x;
            int j = this.y;
            boolean bl2 = this.isClickOutsideBounds(mouseX, mouseY, i, j, button);
            int k = -1;
            if (slot != null) {
                k = slot.field_7874;
            }
            if (bl2) {
                k = -999;
            }
            if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue() && bl2 && this.handler.method_34255().method_7960()) {
                this.method_25419();
                return true;
            }
            if (k != -1) {
                if (((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                    if (slot != null && slot.method_7681()) {
                        this.touchDragSlotStart = slot;
                        this.touchDragStack = class_1799.field_8037;
                        this.touchIsRightClickDrag = button == 1;
                    } else {
                        this.touchDragSlotStart = null;
                    }
                } else if (!this.cursorDragging) {
                    if (this.handler.method_34255().method_7960()) {
                        if (bl) {
                            this.onMouseClick(slot, k, button, class_1713.field_7796);
                        } else {
                            boolean bl3 = k != -999 && (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)340) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)344));
                            class_1713 slotActionType = class_1713.field_7790;
                            if (bl3) {
                                this.quickMovingStack = slot != null && slot.method_7681() ? slot.method_7677().method_7972() : class_1799.field_8037;
                                slotActionType = class_1713.field_7794;
                            } else if (k == -999) {
                                slotActionType = class_1713.field_7795;
                            }
                            this.onMouseClick(slot, k, button, slotActionType);
                        }
                        this.cancelNextRelease = true;
                    } else {
                        this.cursorDragging = true;
                        this.heldButtonCode = button;
                        this.cursorDragSlots.clear();
                        if (button == 0) {
                            this.heldButtonType = 0;
                        } else if (button == 1) {
                            this.heldButtonType = 1;
                        } else if (bl) {
                            this.heldButtonType = 2;
                        }
                    }
                }
            }
        } else {
            this.onMouseClick(button);
        }
        this.lastClickedSlot = slot;
        this.lastButtonClickTime = l;
        this.lastClickedButton = button;
        return true;
    }

    private void onMouseClick(int button) {
        if (this.focusedSlot != null && this.handler.method_34255().method_7960()) {
            if (this.field_22787.field_1690.field_1831.method_1433(button)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 40, class_1713.field_7791);
                return;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_22787.field_1690.field_1852[i].method_1433(button)) continue;
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, i, class_1713.field_7791);
            }
        }
    }

    protected boolean isClickOutsideBounds(double mouseX, double mouseY, int left, int top, int button) {
        for (InventoryComponent value : this.invsComps.values()) {
            if (!value.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.uiAdapter.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        class_1799 itemStack = this.handler.method_34255();
        if (this.touchDragSlotStart != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
            if (button == 0 || button == 1) {
                if (this.touchDragStack.method_7960()) {
                    if (slot != this.touchDragSlotStart && !this.touchDragSlotStart.method_7677().method_7960()) {
                        this.touchDragStack = this.touchDragSlotStart.method_7677().method_7972();
                    }
                } else if (this.touchDragStack.method_7947() > 1 && slot != null && class_1703.method_7592((class_1735)slot, (class_1799)this.touchDragStack, (boolean)false)) {
                    long l = class_156.method_658();
                    if (this.touchHoveredSlot == slot) {
                        if (l - this.touchDropTimer > 500L) {
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, 0, class_1713.field_7790);
                            this.onMouseClick(slot, slot.field_7874, 1, class_1713.field_7790);
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, 0, class_1713.field_7790);
                            this.touchDropTimer = l + 750L;
                            this.touchDragStack.method_7934(1);
                        }
                    } else {
                        this.touchHoveredSlot = slot;
                        this.touchDropTimer = l;
                    }
                }
            }
        } else if (this.cursorDragging && slot != null && !itemStack.method_7960() && (itemStack.method_7947() > this.cursorDragSlots.size() || this.heldButtonType == 2) && class_1703.method_7592((class_1735)slot, (class_1799)itemStack, (boolean)true) && slot.method_7680(itemStack) && this.handler.method_7615(slot)) {
            this.cursorDragSlots.add(slot);
            this.calculateOffset();
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_1735 slot = this.getSlotAt(mouseX, mouseY);
        int i = this.x;
        int j = this.y;
        boolean bl = this.isClickOutsideBounds(mouseX, mouseY, i, j, button);
        int k = -1;
        if (slot != null) {
            k = slot.field_7874;
        }
        if (bl) {
            k = -999;
        }
        if (this.doubleClicking && slot != null && button == 0 && this.handler.method_7613(class_1799.field_8037, slot)) {
            if (MultiInvHandledScreen.method_25442()) {
                if (!this.quickMovingStack.method_7960()) {
                    for (class_1735 slot2 : ((AbstractMultiInvScreenHandler)((Object)this.handler)).field_7761) {
                        if (slot2 == null || !slot2.method_7674((class_1657)this.field_22787.field_1724) || !slot2.method_7681() || slot2.field_7871 != slot.field_7871 || !class_1703.method_7592((class_1735)slot2, (class_1799)this.quickMovingStack, (boolean)true)) continue;
                        this.onMouseClick(slot2, slot2.field_7874, button, class_1713.field_7794);
                    }
                }
            } else {
                this.onMouseClick(slot, k, button, class_1713.field_7793);
            }
            this.doubleClicking = false;
            this.lastButtonClickTime = 0L;
        } else {
            if (this.cursorDragging && this.heldButtonCode != button) {
                this.cursorDragging = false;
                this.cursorDragSlots.clear();
                this.cancelNextRelease = true;
                return true;
            }
            if (this.cancelNextRelease) {
                this.cancelNextRelease = false;
                return true;
            }
            if (this.touchDragSlotStart != null && ((Boolean)this.field_22787.field_1690.method_42446().method_41753()).booleanValue()) {
                if (button == 0 || button == 1) {
                    if (this.touchDragStack.method_7960() && slot != this.touchDragSlotStart) {
                        this.touchDragStack = this.touchDragSlotStart.method_7677();
                    }
                    boolean bl2 = class_1703.method_7592((class_1735)slot, (class_1799)this.touchDragStack, (boolean)false);
                    if (k != -1 && !this.touchDragStack.method_7960() && bl2) {
                        this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, button, class_1713.field_7790);
                        this.onMouseClick(slot, k, 0, class_1713.field_7790);
                        if (this.handler.method_34255().method_7960()) {
                            this.touchDropReturningStack = class_1799.field_8037;
                        } else {
                            this.onMouseClick(this.touchDragSlotStart, this.touchDragSlotStart.field_7874, button, class_1713.field_7790);
                            this.touchDropX = class_3532.method_15357((double)(mouseX - (double)i));
                            this.touchDropY = class_3532.method_15357((double)(mouseY - (double)j));
                            this.touchDropOriginSlot = this.touchDragSlotStart;
                            this.touchDropReturningStack = this.touchDragStack;
                            this.touchDropTime = class_156.method_658();
                        }
                    } else if (!this.touchDragStack.method_7960()) {
                        this.touchDropX = class_3532.method_15357((double)(mouseX - (double)i));
                        this.touchDropY = class_3532.method_15357((double)(mouseY - (double)j));
                        this.touchDropOriginSlot = this.touchDragSlotStart;
                        this.touchDropReturningStack = this.touchDragStack;
                        this.touchDropTime = class_156.method_658();
                    }
                    this.endTouchDrag();
                }
            } else if (this.cursorDragging && !this.cursorDragSlots.isEmpty()) {
                this.onMouseClick(null, -999, class_1703.method_7591((int)0, (int)this.heldButtonType), class_1713.field_7789);
                for (class_1735 slot2 : this.cursorDragSlots) {
                    this.onMouseClick(slot2, slot2.field_7874, class_1703.method_7591((int)1, (int)this.heldButtonType), class_1713.field_7789);
                }
                this.onMouseClick(null, -999, class_1703.method_7591((int)2, (int)this.heldButtonType), class_1713.field_7789);
            } else if (!this.handler.method_34255().method_7960()) {
                if (this.field_22787.field_1690.field_1871.method_1433(button)) {
                    this.onMouseClick(slot, k, button, class_1713.field_7796);
                } else {
                    this.onMouseClick(slot, k, button, class_1713.field_7790);
                }
            }
        }
        if (this.handler.method_34255().method_7960()) {
            this.lastButtonClickTime = 0L;
        }
        this.cursorDragging = false;
        return true;
    }

    public void endTouchDrag() {
        this.touchDragStack = class_1799.field_8037;
        this.touchDragSlotStart = null;
    }

    protected boolean isPointOverSlot(class_1735 slot, double pointX, double pointY) {
        String id = ((AbstractMultiInvScreenHandler)((Object)this.handler)).getInventoryForSlot(slot);
        if (id != null && this.invsComps.containsKey(id)) {
            Pair<Integer, Integer> pos = this.getSlotPosition(slot, id);
            return this.isPointWithinBounds((Integer)pos.getFirst(), (Integer)pos.getSecond(), 16, 16, pointX, pointY);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isPointWithinBounds(int x, int y, int width, int height, double pointX, double pointY) {
        double d;
        double d2;
        int i = this.x;
        int j = this.y;
        pointX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(pointX < (double)(x + width + 1))) return false;
        pointY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(pointY < (double)(y + height + 1))) return false;
        return true;
    }

    protected void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot != null) {
            slotId = slot.field_7874;
        }
        this.field_22787.field_1761.method_2906(((AbstractMultiInvScreenHandler)((Object)this.handler)).field_7763, slotId, button, actionType, (class_1657)this.field_22787.field_1724);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (Owo.DEBUG && this.modelId != null && keyCode == 294 && (modifiers & 2) != 0) {
            this.field_22787.method_1507((class_437)new ConfigureHotReloadScreen(this.modelId, (class_437)this));
            return true;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        this.handleHotbarKeyPressed(keyCode, scanCode);
        if (this.focusedSlot != null && this.focusedSlot.method_7681()) {
            if (this.field_22787.field_1690.field_1871.method_1417(keyCode, scanCode)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 0, class_1713.field_7796);
            } else if (this.field_22787.field_1690.field_1869.method_1417(keyCode, scanCode)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, MultiInvHandledScreen.method_25441() ? 1 : 0, class_1713.field_7795);
            }
        }
        return true;
    }

    protected boolean handleHotbarKeyPressed(int keyCode, int scanCode) {
        if (this.handler.method_34255().method_7960() && this.focusedSlot != null) {
            if (this.field_22787.field_1690.field_1831.method_1417(keyCode, scanCode)) {
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, 40, class_1713.field_7791);
                return true;
            }
            for (int i = 0; i < 9; ++i) {
                if (!this.field_22787.field_1690.field_1852[i].method_1417(keyCode, scanCode)) continue;
                this.onMouseClick(this.focusedSlot, this.focusedSlot.field_7874, i, class_1713.field_7791);
                return true;
            }
        }
        return false;
    }

    public void method_25432() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        this.handler.method_7595((class_1657)this.field_22787.field_1724);
    }

    public boolean method_25421() {
        return false;
    }

    public final void method_25393() {
        super.method_25393();
        if (!this.field_22787.field_1724.method_5805() || this.field_22787.field_1724.method_31481()) {
            this.field_22787.field_1724.method_7346();
        } else {
            this.handledScreenTick();
        }
    }

    protected void handledScreenTick() {
    }

    public T getScreenHandler() {
        return this.handler;
    }

    public void method_25419() {
        this.field_22787.field_1724.method_7346();
        super.method_25419();
    }
}

