/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class BetterEntityComponent<E extends class_1297>
extends EntityComponent<E> {
    protected float mouseRotationY = 0.0f;

    protected BetterEntityComponent(Sizing sizing, E entity) {
        super(sizing, entity);
    }

    protected BetterEntityComponent(Sizing sizing, class_1299<E> type, @Nullable class_2487 nbt) {
        super(sizing, type, nbt);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        matrices.method_22905(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, 75.0f * this.scale);
        matrices.method_46416(0.0f, this.entity.method_17682() / -2.0f, 0.0f);
        this.transform.accept(matrices);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                living.field_6259 = -yRotation;
            }
            this.entity.field_5982 = -yRotation;
            this.entity.field_6004 = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(yRotation * 0.15f));
        } else {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(35.0f + this.mouseRotationY));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-45.0f + this.mouseRotation));
        }
        OwoEntityRenderDispatcherExtension dispatcher = (OwoEntityRenderDispatcherExtension)this.dispatcher;
        dispatcher.owo$setCounterRotate(true);
        dispatcher.owo$setShowNametag(this.showNametag);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.method_3948(false);
        this.dispatcher.method_3954(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (class_4597)this.entityBuffers, 0xF000F0);
        this.dispatcher.method_3948(true);
        this.entityBuffers.method_22993();
        class_308.method_24211();
        matrices.method_22909();
        dispatcher.owo$setCounterRotate(false);
        dispatcher.owo$setShowNametag(true);
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.allowMouseRotation && button == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            this.mouseRotationY = (float)((double)this.mouseRotationY + deltaY);
            super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            return true;
        }
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public static EntityComponent<?> parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"type"});
        class_2960 entityId = UIParsing.parseIdentifier((Node)element.getAttributeNode("type"));
        class_1299 entityType = (class_1299)class_7923.field_41177.method_17966(entityId).orElseThrow(() -> new UIModelParsingException("Unknown entity type " + String.valueOf(entityId)));
        class_2487 nbt = null;
        if (element.hasAttribute("nbt")) {
            try {
                nbt = class_2522.method_10718((String)element.getAttribute("nbt"));
            }
            catch (CommandSyntaxException cse) {
                throw new UIModelParsingException("Invalid NBT compound", (Throwable)cse);
            }
        }
        return new BetterEntityComponent(Sizing.content(), entityType, nbt);
    }
}

