/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.RessourceGuiHelper;
import com.diamssword.greenresurgence.systems.crafting.RecipeCollection;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.UniversalResource;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class ButtonInventoryComponent
extends BaseComponent {
    private final int slotSize = 18;
    public static final class_2960 SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/highlight.png");
    private final EventStream<RecipePicked> onPicked = RecipePicked.newPickStream();
    public class_2960 collectionID;
    private UniversalResource hovered;
    private RecipeCollection collection;
    private int columns = 3;
    private List<SimpleRecipe> items = new ArrayList<SimpleRecipe>();
    private Comparator<SimpleRecipe> sorter;
    private String lastResearch = "";
    protected boolean blend = false;
    private float time = 0.0f;
    private int sizingHeight;

    protected ButtonInventoryComponent(Sizing size, class_2960 collectionID, RecipeCollection collection) {
        this.collectionID = collectionID;
        this.collection = collection;
        this.items = this.collection.getRecipes((class_1657)class_310.method_1551().field_1724);
        this.sizing(size);
    }

    public void bindSearchField(TextBoxComponent field) {
        field.onChanged().subscribe(t -> {
            if (!t.trim().equals(this.lastResearch)) {
                this.lastResearch = t.toLowerCase().trim();
                this.refreshSearch();
            }
        });
    }

    public void setCollection(RecipeCollection collection, class_2960 id) {
        this.collection = collection;
        this.collectionID = id;
        this.refreshSearch();
    }

    public void setSize() {
        this.applySizing();
        if (this.parent != null) {
            this.parent.onChildMutated((Component)this);
        }
    }

    public Comparator<SimpleRecipe> getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator<SimpleRecipe> sorter) {
        this.sorter = sorter;
    }

    public void refreshSearch() {
        class_746 pl = class_310.method_1551().field_1724;
        this.items = this.lastResearch.isBlank() ? this.collection.getRecipes((class_1657)pl) : new ArrayList<SimpleRecipe>(this.collection.getRecipes((class_1657)pl).stream().filter(arg_0 -> this.lambda$refreshSearch$1((class_1657)pl, arg_0)).toList());
        if (this.sorter != null) {
            this.items.sort(this.sorter);
        }
        this.setSize();
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.sizingHeight;
    }

    public void applySizing() {
        super.applySizing();
        this.columns = Math.max(1, this.width / 18);
        this.sizingHeight = (int)(Math.ceil((float)this.items.size() / (float)this.columns) * 18.0);
        super.applySizing();
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        int x = (int)mouseX / 18;
        int y = (int)mouseY / 18;
        int d = x + y * this.columns;
        if (x < this.columns && d < this.items.size()) {
            UISounds.playButtonSound();
            ((RecipePicked)this.onPicked.sink()).onPicked(this.items.get(d), this.collection, this.collectionID);
            return false;
        }
        return super.onMouseDown(mouseX, mouseY, button);
    }

    public EventSource<RecipePicked> onRecipePicked() {
        return this.onPicked.source();
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (!class_437.method_25441()) {
            this.time += delta;
        }
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        int i = 0;
        int j = 0;
        this.hovered = null;
        for (SimpleRecipe item : this.items) {
            UniversalResource it = item.result((class_1657)class_310.method_1551().field_1724);
            int w1 = i * 18;
            int h1 = j * 18;
            if (mouseX >= this.x + w1 && mouseX <= this.x + w1 + 18 - 1 && mouseY >= this.y + h1 && mouseY <= this.y + h1 + 18 - 1) {
                this.hovered = it;
                context.method_25290(SLOT_TEXTURE, w1, h1, 0.0f, 0.0f, 18, 18, 32, 32);
            }
            this.drawResource(it, context, w1 + 1, h1 + 1);
            if (++i < this.columns) continue;
            ++j;
            i = 0;
        }
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    protected void drawResource(UniversalResource resource, OwoUIDrawContext context, int x, int y) {
        RessourceGuiHelper.drawRessource(context, resource, x, y, this.time);
    }

    public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
        RessourceGuiHelper.drawTooltip(context, this.hovered, mouseX, mouseY, this.time);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
    }

    public static ButtonInventoryComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"collection"});
        class_2960 invId = UIParsing.parseIdentifier((Node)element.getAttributeNode("collection"));
        RecipeCollection r = Recipes.get(invId).orElse(new RecipeCollection(new class_2960("minecraft:void")));
        return new ButtonInventoryComponent(Sizing.fill((int)100), invId, r);
    }

    private /* synthetic */ boolean lambda$refreshSearch$1(class_1657 pl, SimpleRecipe v) {
        return v.result(pl).getName().getString().toLowerCase().trim().contains(this.lastResearch);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RecipePicked {
        public boolean onPicked(SimpleRecipe var1, RecipeCollection var2, class_2960 var3);

        public static EventStream<RecipePicked> newPickStream() {
            return new EventStream(subscribers -> (picked, collection, collectionID) -> {
                boolean anyTriggered = false;
                for (RecipePicked subscriber : subscribers) {
                    anyTriggered |= subscriber.onPicked(picked, collection, collectionID);
                }
                return anyTriggered;
            });
        }
    }
}

