/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.render.cosmetics.ClothingModel;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.joml.Vector3f;
import org.w3c.dom.Element;

@Environment(value=EnvType.CLIENT)
public class CharacterComponent
extends BaseComponent {
    protected final class_898 dispatcher;
    protected final class_4597.class_4598 entityBuffers;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;
    public class_745 entity;
    protected Consumer<class_4587> transform = matrixStack -> {};
    private Map<String, Layer> layers = new HashMap<String, Layer>();
    public float charHeight = 1.0f;
    public float charWidth = 1.0f;

    protected CharacterComponent(Sizing sizing) {
        class_310 client = class_310.method_1551();
        this.entity = new class_745(client.field_1687, client.field_1724.method_7334());
        this.dispatcher = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
        this.sizing(sizing);
    }

    public Optional<Layer> getLayer(String name) {
        return Optional.ofNullable(this.layers.get(name));
    }

    public Layer createLayer(String name, int order, boolean secondLayer, class_2960 texture) {
        Layer l = new Layer(order, secondLayer, texture);
        this.layers.put(name, l);
        return l;
    }

    public void renderLayer(Layer layer, class_4587 matrices, class_4597 vertexConsumers, int light, class_742 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress) {
        class_1007 r = (class_1007)this.dispatcher.method_3953((class_1297)entity);
        ((class_591)r.method_4038()).method_2818(layer.model);
        layer.model.field_3448 = false;
        layer.model.method_17086((class_1309)entity, limbAngle, limbDistance, tickDelta);
        layer.model.method_17087(entity, limbAngle, limbDistance, animationProgress, entity.field_6259, entity.field_6004);
        matrices.method_22905(this.charWidth, this.charHeight, this.charWidth);
        layer.model.method_2828(matrices, vertexConsumers.getBuffer(layer.model.method_23500(layer.texture)), light, class_922.method_23622((class_1309)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        matrices.method_22905(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, 75.0f * this.scale);
        matrices.method_46416(0.0f, this.entity.method_17682() * this.charHeight / 4.0f, 0.0f);
        this.transform.accept(matrices);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            this.entity.field_6259 = -yRotation;
            this.entity.field_5982 = -yRotation;
            this.entity.field_6004 = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(xRotation * 0.15f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(yRotation * 0.15f));
        } else {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(35.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-45.0f + this.mouseRotation));
        }
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        OwoEntityRenderDispatcherExtension dispatcher = (OwoEntityRenderDispatcherExtension)this.dispatcher;
        dispatcher.owo$setCounterRotate(true);
        dispatcher.owo$setShowNametag(false);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.method_3948(false);
        this.layers.forEach((k, v) -> this.renderLayer((Layer)v, matrices, (class_4597)this.entityBuffers, 0xF000F0, (class_742)this.entity, 0.0f, 0.0f, partialTicks, 0.0f));
        this.dispatcher.method_3948(true);
        this.entityBuffers.method_22993();
        class_308.method_24211();
        matrices.method_22909();
        dispatcher.owo$setCounterRotate(false);
        dispatcher.owo$setShowNametag(true);
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        if (this.allowMouseRotation && button == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            return true;
        }
        return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public CharacterComponent allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public CharacterComponent lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public CharacterComponent scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public CharacterComponent scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.5f / this.entity.method_17681();
            float yScale = 0.5f / this.entity.method_17682();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    public CharacterComponent transform(Consumer<class_4587> transform) {
        this.transform = transform;
        return this;
    }

    public Consumer<class_4587> transform() {
        return this.transform;
    }

    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"scale", UIParsing::parseFloat, this::scale);
        UIParsing.apply(children, (String)"look-at-cursor", UIParsing::parseBool, this::lookAtCursor);
        UIParsing.apply(children, (String)"mouse-rotation", UIParsing::parseBool, this::allowMouseRotation);
        UIParsing.apply(children, (String)"scale-to-fit", UIParsing::parseBool, this::scaleToFit);
    }

    public static CharacterComponent parse(Element element) {
        return new CharacterComponent(Sizing.content());
    }

    @Environment(value=EnvType.CLIENT)
    public static class Layer {
        public ClothingModel<class_742> model;
        public class_2960 texture;

        public Layer(int order, boolean secondLayer, class_2960 texture) {
            this.model = new ClothingModel(false, order, secondLayer);
            this.texture = texture;
        }
    }
}

