/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.greenresurgence.gui.components.Panels;
import com.diamssword.greenresurgence.render.cosmetics.ClothingModel;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.mixin.ui.access.ClickableWidgetAccessor;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import io.wispforest.owo.util.pond.OwoEntityRenderDispatcherExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_8001;
import net.minecraft.class_898;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClothButtonComponent
extends ButtonComponent {
    private static final String CLOTH_MOD_ID = "character_sheet";
    private Cloth cloth;
    private final ClothingModel<class_742> model = new ClothingModel(false, 0, false);
    private final ClothingModel<class_742> model1 = new ClothingModel(false, 1, true);
    protected final class_898 dispatcher;
    protected final class_4597.class_4598 entityBuffers;
    private boolean hoveredSent = false;
    private boolean selected = false;
    private final EventStream<ClothPicked> onHovered = ClothPicked.newPickStream();

    public ClothButtonComponent(Cloth cloth) {
        super((class_2561)class_2561.method_43470((String)""), a -> {});
        this.setCloth(cloth);
        class_310 client = class_310.method_1551();
        this.dispatcher = client.method_1561();
        this.entityBuffers = client.method_22940().method_23000();
    }

    public void setCloth(Cloth cloth) {
        this.cloth = cloth;
        class_5250 tool = class_2561.method_43470((String)cloth.name().replaceAll("/", " ").replaceAll("_", " "));
        if (!cloth.collection().equals("default")) {
            tool.method_10852((class_2561)class_2561.method_43470((String)("\n" + cloth.collection())).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        }
        this.tooltip((class_2561)tool);
    }

    public Cloth getCloth() {
        return this.cloth;
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public EventSource<ClothPicked> onClothHovered() {
        return this.onHovered.source();
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (this.selected) {
            context.method_51422(0.8f, 1.0f, 0.8f, 1.0f);
        }
        Panels.drawOverlay(context, this.x(), this.y(), this.field_22758, this.field_22759);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawClothing(context, mouseX);
        boolean bl = this.field_22762 = mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
        if (this.field_22762) {
            if (!this.hoveredSent) {
                ((ClothPicked)this.onHovered.sink()).onPicked(this.cloth);
            }
            this.hoveredSent = true;
            class_7919 tooltip = ((ClickableWidgetAccessor)this).owo$getTooltip();
            if (tooltip != null) {
                class_327 textRenderer = class_310.method_1551().field_1772;
                context.method_51436(textRenderer, tooltip.method_47405(class_310.method_1551()), class_8001.field_41687, mouseX, mouseY);
            }
        } else if (this.hoveredSent) {
            ((ClothPicked)this.onHovered.sink()).onPicked(null);
            this.hoveredSent = false;
        }
    }

    public void drawClothing(OwoUIDrawContext context, int mouseX) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        float scale = this.cloth.layer().getDisplayMode() == 1 ? (float)(this.cloth.layer().getDisplayMode() == 2 ? 40 : 30) : 20.0f;
        matrices.method_46416((float)this.x() + (float)this.field_22758 / 2.0f, (float)this.y() + (float)this.field_22759 / 2.0f - 8.0f, 100.0f);
        if (this.cloth.layer().getDisplayMode() != 0) {
            if (this.cloth.layer().getDisplayMode() == 2) {
                matrices.method_46416(0.0f, -((float)this.field_22759 * 0.8f), 0.0f);
            } else {
                matrices.method_46416(0.0f, (float)this.field_22759 / 3.0f, 0.0f);
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.0f));
        }
        matrices.method_22905(scale, scale, scale);
        float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.method_46426()) - (float)this.field_22758 / 2.0f) / 40.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f + yRotation * 0.6f));
        OwoEntityRenderDispatcherExtension dispatcher = (OwoEntityRenderDispatcherExtension)this.dispatcher;
        dispatcher.owo$setCounterRotate(true);
        dispatcher.owo$setShowNametag(false);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.method_3948(false);
        this.renderLayer(matrices, (class_4597)this.entityBuffers, 0xF000F0);
        this.dispatcher.method_3948(true);
        this.entityBuffers.method_22993();
        class_308.method_24211();
        matrices.method_22909();
        dispatcher.owo$setCounterRotate(false);
        dispatcher.owo$setShowNametag(true);
    }

    public void renderLayer(class_4587 matrices, class_4597 vertexConsumers, int light) {
        this.model.field_3448 = false;
        this.model1.field_3448 = false;
        int pack = class_4608.method_23625((int)class_4608.method_23210((float)0.0f), (int)class_4608.method_23212((boolean)false));
        this.model.method_2828(matrices, vertexConsumers.getBuffer(this.model.method_23500(new class_2960(this.cloth.id().method_12836(), "textures/cloth/" + this.cloth.id().method_12832() + ".png"))), light, pack, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model1.method_2828(matrices, vertexConsumers.getBuffer(this.model1.method_23500(new class_2960(this.cloth.id().method_12836(), "textures/cloth/" + this.cloth.id().method_12832() + ".png"))), light, pack, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ClothPicked {
        public void onPicked(Cloth var1);

        public static EventStream<ClothPicked> newPickStream() {
            return new EventStream(subscribers -> cloth -> {
                for (ClothPicked subscriber : subscribers) {
                    subscriber.onPicked(cloth);
                }
            });
        }
    }
}

