/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components;

import com.diamssword.greenresurgence.GreenResurgence;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class ScrollInventoryComponent
extends BaseComponent {
    public static final class_2960 SLOT_TEXTURE = GreenResurgence.asRessource("textures/gui/slot.png");
    public final String inventoryId;
    public final String name;
    protected final AnimatableProperty<PositionedRectangle> visibleArea;
    private int regionWidth = 18;
    private int regionHeight = 18;
    protected boolean blend = false;
    private class_1263 inventory;
    private List<class_1799> list = new ArrayList<class_1799>();

    public void setInventory(class_1263 inventory) {
    }

    private void refreshItems() {
    }

    protected ScrollInventoryComponent(String inventoryId, int width, int height, String name) {
        this.inventoryId = inventoryId;
        this.name = name;
        this.regionWidth = width * 18;
        this.regionHeight = 10 + height * 18;
        this.visibleArea = AnimatableProperty.of((Animatable)PositionedRectangle.of((int)0, (int)0, (int)this.regionWidth, (int)this.regionHeight));
    }

    protected ScrollInventoryComponent(String inventoryId, int width, int height) {
        this(inventoryId, width, height, inventoryId);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.regionWidth;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.regionHeight;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.visibleArea.update(delta);
    }

    public class_2561 getInventoryName() {
        if (this.name.equals("disabled")) {
            return null;
        }
        if (this.inventoryId.equals("player")) {
            return class_2561.method_43471((String)"container.inventory");
        }
        if (this.inventoryId.equals("hotbar") || this.name.isEmpty()) {
            return null;
        }
        return class_2561.method_43471((String)("green_resurgence.container." + this.name));
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        matrices.method_22905((float)this.width / (float)this.regionWidth, (float)this.height / (float)this.regionHeight, 0.0f);
        PositionedRectangle visibleArea = (PositionedRectangle)this.visibleArea.get();
        int bottomEdge = Math.min(visibleArea.y() + visibleArea.height(), this.regionHeight);
        int rightEdge = Math.min(visibleArea.x() + visibleArea.width(), this.regionWidth);
        class_2561 name = this.getInventoryName();
        if (name != null) {
            context.drawText(name, (float)visibleArea.x(), (float)visibleArea.y(), 0.9f, 0xFFFFFF);
        }
        context.method_25293(SLOT_TEXTURE, visibleArea.x() - 1, visibleArea.y() + 9, rightEdge - visibleArea.x(), bottomEdge - visibleArea.y() - 10, (float)visibleArea.x(), (float)visibleArea.y(), rightEdge - visibleArea.x(), bottomEdge - visibleArea.y() - 10, 18, 18);
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    public ScrollInventoryComponent visibleArea(PositionedRectangle visibleArea) {
        this.visibleArea.set((Object)visibleArea);
        return this;
    }

    public ScrollInventoryComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    public boolean blend() {
        return this.blend;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"blend", UIParsing::parseBool, this::blend);
        if (children.containsKey("visible-area")) {
            Map areaChildren = UIParsing.childElements((Element)children.get("visible-area"));
            int x = 0;
            int y = 0;
            int width = this.regionWidth;
            int height = this.regionHeight;
            if (areaChildren.containsKey("x")) {
                x = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("x")));
            }
            if (areaChildren.containsKey("y")) {
                y = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("y")));
            }
            if (areaChildren.containsKey("width")) {
                width = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("width")));
            }
            if (areaChildren.containsKey("height")) {
                height = UIParsing.parseSignedInt((Node)((Node)areaChildren.get("height")));
            }
            this.visibleArea(PositionedRectangle.of((int)x, (int)y, (int)width, (int)height));
        }
    }

    public static ScrollInventoryComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"id"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"width"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"height"});
        String invId = element.getAttributeNode("id").getValue();
        int w = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("width"));
        int h = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("height"));
        if (element.hasAttribute("name")) {
            return new ScrollInventoryComponent(invId, w, h, element.getAttributeNode("name").getValue());
        }
        return new ScrollInventoryComponent(invId, w, h);
    }
}

