/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components.hud;

import com.diamssword.greenresurgence.gui.components.hud.IHideableComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class HealthBarComponent
extends BaseComponent
implements IHideableComponent {
    private int count = 10;
    private int lastHealthValue;
    private int renderHealthValue;
    private long lastHealthCheckTime;
    private long heartJumpEndTick;
    protected boolean blend = false;
    protected final class_2960 texture;
    private final Random random = new Random();
    private int ticks;
    private boolean hidden;

    protected HealthBarComponent(class_2960 texture) {
        this.texture = texture;
    }

    @Override
    public void hidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public HealthBarComponent blend(boolean blend) {
        this.blend = blend;
        return this;
    }

    public HealthBarComponent count(int count) {
        this.count = count;
        return this;
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
    }

    public void tick() {
        ++this.ticks;
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        Sizing v = (Sizing)this.verticalSizing.get();
        if (v != null && !v.isContent() && this.height > 0) {
            return (int)((float)(this.height * this.count) * 0.8888889f) + 1;
        }
        return 8 * this.count;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return 9;
    }

    protected void applySizing() {
        Sizing horizontalSizing = (Sizing)this.horizontalSizing.get();
        Sizing verticalSizing = (Sizing)this.verticalSizing.get();
        Insets margins = (Insets)this.margins.get();
        this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
        this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
    }

    private void renderBar(class_332 context, class_1657 playerEntity, int x, int y) {
        if (this.hidden) {
            return;
        }
        int i = class_3532.method_15386((float)playerEntity.method_6032());
        boolean bl = this.heartJumpEndTick > (long)this.ticks && (this.heartJumpEndTick - (long)this.ticks) / 3L % 2L == 1L;
        long l = class_156.method_658();
        if (i < this.lastHealthValue && playerEntity.field_6008 > 0) {
            this.lastHealthCheckTime = l;
            this.heartJumpEndTick = this.ticks + 20;
        } else if (i > this.lastHealthValue && playerEntity.field_6008 > 0) {
            this.lastHealthCheckTime = l;
            this.heartJumpEndTick = this.ticks + 10;
        }
        if (l - this.lastHealthCheckTime > 1000L) {
            this.renderHealthValue = i;
            this.lastHealthCheckTime = l;
        }
        this.lastHealthValue = i;
        int j = this.renderHealthValue;
        this.random.setSeed(this.ticks * 312871);
        float f = Math.max((float)playerEntity.method_26825(class_5134.field_23716), (float)Math.max(j, i));
        int p = class_3532.method_15386((float)playerEntity.method_6067());
        int v = -1;
        if (playerEntity.method_6059(class_1294.field_5924)) {
            v = this.ticks % class_3532.method_15386((float)(f + 5.0f));
        }
        this.renderHealthBar(context, playerEntity, x, y, v, f, i, j, p, bl, 0.5f);
    }

    private void renderHealthBar(class_332 context, class_1657 player, int x, int y, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking, float trueHeartPercent) {
        HeartType heartType = HeartType.fromPlayerState(player);
        int i = 0;
        int j = class_3532.method_15384((double)((double)maxHealth / 2.0));
        float perc = (float)health / maxHealth;
        float perc1 = (float)lastHealth / maxHealth;
        int l = j * 2;
        for (int m = 0; m < this.count; ++m) {
            HeartType type1;
            int n = m / this.count;
            int o = m % this.count;
            int p = x + o * (int)((float)this.height * 0.8888889f);
            int q = y - n;
            if ((float)m / (float)this.count < trueHeartPercent && perc1 < trueHeartPercent) {
                q += this.random.nextInt(2);
            }
            if (m < j && m == regeneratingHeartIndex) {
                q -= 2;
            }
            this.drawHeart(context, HeartType.CONTAINER, p, q, i, blinking, 1.0f);
            HeartType heartType2 = type1 = (float)m / (float)this.count >= trueHeartPercent ? HeartType.ABSORBING : HeartType.TRUE;
            if ((float)m / (float)this.count >= trueHeartPercent) {
                if (perc1 > trueHeartPercent && heartType != HeartType.TRUE) {
                    type1 = heartType;
                }
            } else if (perc1 < trueHeartPercent) {
                type1 = heartType;
            }
            if (blinking && (perc1 > trueHeartPercent && (float)m > trueHeartPercent * (float)this.count || perc1 < trueHeartPercent && (float)m < trueHeartPercent * (float)this.count)) {
                this.drawHeart(context, type1, p, q, i, true, 1.0f);
            }
            if (!((float)m < perc1 * (float)this.count)) continue;
            float per = Math.min(perc1 * (float)this.count - (float)m, 1.0f);
            boolean b = false;
            if (blinking && lastHealth > health) {
                b = (float)m >= perc * (float)this.count;
            }
            this.drawHeart(context, type1, p, q, i, b, per);
        }
    }

    private void drawHeart(class_332 context, HeartType type, int x, int y, int v, boolean blinking, float fillPercent) {
        context.method_25293(this.texture, x, y, (int)((float)this.height * fillPercent), this.height, (float)type.getU(blinking), (float)v, (int)(9.0f * fillPercent), 9, 180, 9);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            this.renderBar((class_332)context, (class_1657)client.field_1724, 0, 0);
        }
        if (this.blend) {
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"blend", UIParsing::parseBool, this::blend);
        UIParsing.apply(children, (String)"count", UIParsing::parseSignedInt, this::count);
    }

    public static HealthBarComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture"});
        class_2960 textureId = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        return new HealthBarComponent(new class_2960(textureId.method_12836(), "textures/gui/" + textureId.method_12832()));
    }

    @Environment(value=EnvType.CLIENT)
    static enum HeartType {
        CONTAINER(0, false),
        NORMAL(1, true),
        POISONED(2, true),
        WITHERED(3, true),
        ABSORBING(4, true),
        TRUE(5, true),
        FROZEN(6, false);

        private final int textureIndex;
        private final boolean hasBlinkingTexture;

        private HeartType(int textureIndex, boolean hasBlinkingTexture) {
            this.textureIndex = textureIndex;
            this.hasBlinkingTexture = hasBlinkingTexture;
        }

        public int getU(boolean blinking) {
            int i = this.hasBlinkingTexture && blinking ? 1 : 0;
            return (this.textureIndex * 2 + i) * 9;
        }

        static HeartType fromPlayerState(class_1657 player) {
            HeartType heartType = player.method_6059(class_1294.field_5899) ? POISONED : (player.method_6059(class_1294.field_5920) ? WITHERED : (player.method_32314() ? FROZEN : TRUE));
            return heartType;
        }
    }
}

