/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.components.hud;

import com.diamssword.greenresurgence.DrawUtils;
import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.gui.components.hud.IHideableComponent;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.HealthManager;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class HealthIconComponent
extends TextureComponent
implements IHideableComponent {
    private static final float SHIELD_TRANSPARENCY = 0.6f;
    private static final int HEART_COUNT = 20;
    private static final float HEART_SCALE = 0.7f;
    private static final int SHIELD_T_W = 192;
    private static final int SHIELD_T_H = 64;
    private static final class_2960 SHIELD_TEXTURE = GreenResurgence.asRessource("textures/gui/hud/shield.png");
    private boolean hidden;
    private int hideTimer = 200;
    public boolean blink = false;
    public boolean shieldblink = false;
    public boolean sideBlink = false;
    private int blinkTime = 0;
    private int blinkTimeShield = 0;
    public float filling = 1.0f;
    public float fillingShield = 1.0f;
    public float goal = 1.0f;
    public float goalShield = 1.0f;
    private final HeartType type = HeartType.NORMAL;

    protected HealthIconComponent(class_2960 texture, int u, int v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        super(texture, u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        Sizing v = (Sizing)this.verticalSizing.get();
        if (v != null && !v.isContent() && this.height > 0) {
            return (int)((float)this.height * ((float)this.regionWidth / (float)this.regionHeight));
        }
        return this.regionWidth;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        Sizing v = (Sizing)this.horizontalSizing.get();
        if (v != null && !v.isContent() && this.width > 0) {
            return (int)((float)this.width * ((float)this.regionHeight / (float)this.regionWidth));
        }
        return this.regionHeight;
    }

    protected void applySizing() {
        Sizing horizontalSizing = (Sizing)this.horizontalSizing.get();
        Sizing verticalSizing = (Sizing)this.verticalSizing.get();
        Insets margins = (Insets)this.margins.get();
        if (verticalSizing.isContent()) {
            this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
            this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
        } else {
            this.height = verticalSizing.inflate(this.space.height() - margins.vertical(), this::determineVerticalContentSize);
            this.width = horizontalSizing.inflate(this.space.width() - margins.horizontal(), this::determineHorizontalContentSize);
        }
    }

    public void animateForHealth(class_1657 pl) {
        float v = pl.method_6032() / pl.method_6063();
        if (v > this.goal) {
            this.blinkTime = 5;
        }
        boolean bl = this.blink = this.blinkTime > 0;
        if (this.blinkTime > 0) {
            --this.blinkTime;
        }
        this.sideBlink = pl.field_6235 > 0 && v < this.goal;
        this.goal = v;
        if (this.filling < this.goal) {
            this.filling = Math.min(this.goal, this.filling + 0.1f);
        } else if (this.filling > this.goal) {
            this.filling = Math.max(this.goal, this.filling - 0.1f);
        }
        if (this.filling < 1.0f || this.fillingShield < 1.0f) {
            this.hideTimer = 200;
        } else if (this.hideTimer > 0) {
            --this.hideTimer;
        }
    }

    public void animateForShield(class_1657 pl) {
        HealthManager man = ((PlayerData)pl.getComponent(Components.PLAYER_DATA)).healthManager;
        double v = man.getShieldAmount() / man.getMaxShieldAmount();
        if (v > (double)this.goalShield) {
            this.blinkTimeShield = 5;
        }
        boolean bl = this.shieldblink = this.blinkTimeShield > 0;
        if (this.blinkTimeShield > 0) {
            --this.blinkTimeShield;
        }
        this.goalShield = (float)v;
        if (this.fillingShield < this.goalShield) {
            this.fillingShield = Math.min(this.goalShield, this.fillingShield + 0.1f);
        } else if (this.fillingShield > this.goalShield) {
            this.fillingShield = Math.max(this.goalShield, this.fillingShield - 0.1f);
        }
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        RenderSystem.enableDepthTest();
        if (this.hidden || this.hideTimer == 0) {
            return;
        }
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x, (float)this.y, 0.0f);
        class_310 cl = class_310.method_1551();
        if (cl.field_1724 != null) {
            if (this.blend) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min((float)this.hideTimer / 100.0f * 0.6f, 0.6f));
            }
            this.drawShield((class_332)context, this.shieldblink, 64.0f, this.fillingShield);
            if (this.blend) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.hideTimer / 100.0f));
            }
            DrawUtils.drawTexture((class_332)context, SHIELD_TEXTURE, 0.0f, 0.0f, this.width, this.height, 0.0f, 0.0f, 64.0f, 64.0f, 192, 64);
            float a = (int)((float)this.width * 0.7f);
            matrices.method_46416(((float)this.width - a) / 2.0f, ((float)this.width - a) / 2.0f, 0.0f);
            this.drawGauge((class_332)context, this.getU(this.type, this.blink), 9.0f, this.filling, a, a);
            context.method_25293(this.texture, 0, 0, (int)a, (int)a, this.getU(HeartType.CONTAINER, this.sideBlink), (float)this.v, this.regionWidth, this.regionHeight, this.textureWidth, this.textureHeight);
        }
        if (this.blend) {
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrices.method_22909();
    }

    private float getU(HeartType type, boolean blinking) {
        int i = blinking ? 1 : 0;
        float d = (float)this.textureWidth / 20.0f;
        return (float)(type.textureIndex * 2 + i) * d;
    }

    private void drawShield(class_332 ctx, boolean blink, float pxSpace, float fill) {
        float ipx = 64.0f / pxSpace;
        int ih = (int)((float)this.height / pxSpace);
        fill = class_3532.method_15363((float)fill, (float)0.0f, (float)1.0f);
        float rh = 64.0f - ipx * 2.0f;
        float uvHeight = rh * fill;
        float uvYOffset = 64.0f - ipx - uvHeight;
        int drawHeightVisible = (int)((float)(this.height - ih * 2) * fill);
        int yOffset = this.height - ih - drawHeightVisible;
        DrawUtils.drawTexture(ctx, SHIELD_TEXTURE, 0.0f, yOffset, this.width, drawHeightVisible, 64 * (blink ? 2 : 1), uvYOffset, 64.0f, uvHeight, 192, 64);
    }

    private void drawGauge(class_332 ctx, float uIndex, float pxSpace, float fill, float width, float height) {
        float ipx = (float)this.textureHeight / pxSpace;
        float ih = height / pxSpace;
        fill = class_3532.method_15363((float)fill, (float)0.0f, (float)1.0f);
        float rh = (float)this.regionHeight - ipx * 2.0f;
        float uvHeight = rh * fill;
        float uvYOffset = (float)this.regionHeight - ipx - uvHeight;
        float drawHeightVisible = (height - ih * 2.0f) * fill;
        float yOffset = height - ih - drawHeightVisible;
        DrawUtils.drawTexture(ctx, this.texture, 0.0f, yOffset, width, drawHeightVisible, uIndex, uvYOffset, this.regionWidth, uvHeight, this.textureWidth, this.textureHeight);
    }

    public static HealthIconComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture"});
        class_2960 textureId = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        int u = 0;
        int v = 0;
        int regionWidth = 0;
        int regionHeight = 0;
        int textureWidth = 256;
        int textureHeight = 256;
        if (element.hasAttribute("u")) {
            u = UIParsing.parseSignedInt((Node)element.getAttributeNode("u"));
        }
        if (element.hasAttribute("v")) {
            v = UIParsing.parseSignedInt((Node)element.getAttributeNode("v"));
        }
        if (element.hasAttribute("region-width")) {
            regionWidth = UIParsing.parseSignedInt((Node)element.getAttributeNode("region-width"));
        }
        if (element.hasAttribute("region-height")) {
            regionHeight = UIParsing.parseSignedInt((Node)element.getAttributeNode("region-height"));
        }
        if (element.hasAttribute("texture-width")) {
            textureWidth = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-width"));
        }
        if (element.hasAttribute("texture-height")) {
            textureHeight = UIParsing.parseSignedInt((Node)element.getAttributeNode("texture-height"));
        }
        return new HealthIconComponent(new class_2960(textureId.method_12836(), "textures/gui/" + textureId.method_12832()), u, v, regionWidth, regionHeight, textureWidth, textureHeight);
    }

    @Override
    public void hidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Environment(value=EnvType.CLIENT)
    static enum HeartType {
        SHIELD(0),
        CONTAINER(1),
        NORMAL(2),
        POISONED(3),
        WITHERED(4),
        ABSORBING(5),
        TRUE(6),
        FROZEN(7);

        private final int textureIndex;

        private HeartType(int textureIndex) {
            this.textureIndex = textureIndex;
        }

        static HeartType fromPlayerState(class_1657 player) {
            HeartType heartType = player.method_6059(class_1294.field_5899) ? POISONED : (player.method_6059(class_1294.field_5920) ? WITHERED : (player.method_32314() ? FROZEN : (player.method_6059(class_1294.field_5898) && player.method_6067() > 0.0f ? ABSORBING : TRUE)));
            return heartType;
        }
    }
}

