/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.gui.hud;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.containers.player.CustomPlayerInventory;
import com.diamssword.greenresurgence.gui.components.hud.BarComponent;
import com.diamssword.greenresurgence.gui.components.hud.HealthIconComponent;
import com.diamssword.greenresurgence.gui.components.hud.HotBarComponent;
import com.diamssword.greenresurgence.gui.components.hud.IconComponent;
import com.diamssword.greenresurgence.gui.components.hud.ItemTooltipComponent;
import com.diamssword.greenresurgence.gui.components.hud.SingleSlotComponent;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerData;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class HudGui
extends BaseUIModelScreen<FlowLayout> {
    public static final int blueColor = -11219219;
    private FlowLayout root;
    private final List<Runnable> tickers = new ArrayList<Runnable>();

    protected HudGui() {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)GreenResurgence.asRessource("hud")));
    }

    private boolean hideBars() {
        return !this.field_22787.field_1761.method_2908();
    }

    private class_1657 getCameraPlayer() {
        return !(this.field_22787.method_1560() instanceof class_1657) ? null : (class_1657)this.field_22787.method_1560();
    }

    private class_1309 getRiddenEntity() {
        class_1657 playerEntity = this.getCameraPlayer();
        if (playerEntity != null) {
            class_1297 entity = playerEntity.method_5854();
            if (entity == null) {
                return null;
            }
            if (entity instanceof class_1309) {
                return (class_1309)entity;
            }
        }
        return null;
    }

    protected void build(FlowLayout rootComponent) {
        this.root = rootComponent;
        this.tickers.clear();
        this.attachWithTicker(HealthIconComponent.class, "health", h -> {
            if (this.field_22787.field_1724 != null) {
                h.animateForHealth((class_1657)this.field_22787.field_1724);
                h.animateForShield((class_1657)this.field_22787.field_1724);
            }
            h.hidden(this.hideBars());
        });
        this.attachWithTicker(BarComponent.class, "mountHealth", h -> {
            class_1309 rid = this.getRiddenEntity();
            if (rid != null) {
                float p = rid.method_6032() / rid.method_6063();
                h.setFillPercent(p);
            }
            h.hidden(rid == null);
        });
        this.attachWithTicker(BarComponent.class, "mountJump", h -> {
            h.setFillPercent(this.field_22787.field_1724.method_3151());
            h.hidden(this.field_22787.field_1724.method_45773() == null);
        });
        this.attachWithTicker(BarComponent.class, "air", h -> {
            float p = (float)this.field_22787.field_1724.method_5669() / (float)this.field_22787.field_1724.method_5748();
            h.setFillPercent(p);
            h.hidden(this.hideBars() || p >= 1.0f);
        });
        this.attachWithTicker(BarComponent.class, "stamina", h -> {
            PlayerData dt = (PlayerData)this.field_22787.field_1724.getComponent(Components.PLAYER_DATA);
            double p = dt.healthManager.getEnergyAmount() / dt.healthManager.getMaxEnergyAmount();
            h.animateFillPercent((float)p);
            h.tick();
            h.hidden(this.hideBars() || p >= 1.0);
        });
        this.attachWithTicker(IconComponent.class, "airIcon", h -> {
            float p = (float)this.field_22787.field_1724.method_5669() / (float)this.field_22787.field_1724.method_5748();
            h.hidden(this.hideBars() || p >= 1.0f);
        });
        this.attachWithTicker(ItemTooltipComponent.class, "heldtooltip", h -> {
            h.tick();
            h.hidden(this.field_22787.field_1761.method_2920() == class_1934.field_9219);
        });
        this.attachWithTicker(HotBarComponent.class, "hotbar", h -> {
            h.hidden(this.field_22787.field_1761.method_2920() == class_1934.field_9219);
            int max = CustomPlayerInventory.getHotbarSlotCount((class_1657)this.field_22787.field_1724);
            class_2371 ls = class_2371.method_10213((int)max, (Object)class_1799.field_8037);
            for (int i = 0; i < max; ++i) {
                ls.set(i, (Object)((class_1799)this.field_22787.field_1724.method_31548().field_7547.get(i)));
            }
            boolean b = (float)max != h.getSize();
            h.setStacks((class_2371<class_1799>)ls);
            this.root.onChildMutated((Component)h);
            h.setSelected(this.field_22787.field_1724.method_31548().field_7545);
            if (b) {
                this.method_25410(this.field_22787, 0, 0);
                this.method_25410(this.field_22787, this.field_22787.method_22683().method_4486(), this.field_22787.method_22683().method_4502());
            }
        });
        this.attachWithTicker(SingleSlotComponent.class, "offhandleft", h -> {
            boolean ind = this.field_22787.field_1724.method_6068().method_5928() != class_1306.field_6182;
            h.setIndicatorMode(ind);
            class_1799 st = this.field_22787.field_1724.method_6079();
            if (!ind) {
                h.hidden(st.method_7960());
            }
            h.setStacks(st);
        });
        this.attachWithTicker(SingleSlotComponent.class, "offhandright", h -> {
            boolean ind = this.field_22787.field_1724.method_6068().method_5928() != class_1306.field_6183;
            h.setIndicatorMode(ind);
            class_1799 st = this.field_22787.field_1724.method_6079();
            if (!ind) {
                h.hidden(st.method_7960());
            }
            h.setStacks(st);
        });
        this.attachWithTicker(IconComponent.class, "armorIcon", h -> {
            int arm = this.field_22787.field_1724.method_6096();
            h.hidden(this.hideBars() || arm <= 0);
        });
        this.attachWithTicker(LabelComponent.class, "armorText", h -> {
            int arm = this.field_22787.field_1724.method_6096();
            if (!this.hideBars() && arm > 0) {
                h.text((class_2561)class_2561.method_43470((String)("" + arm)).method_10862(class_2583.field_24360.method_36139(-11219219)));
            } else {
                h.text((class_2561)class_2561.method_43470((String)""));
            }
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private <T extends Component> void attachWithTicker(@NotNull Class<T> expectedClass, @NotNull String id, Consumer<T> ticker) {
        Component comp = this.root.childById(expectedClass, id);
        if (comp != null) {
            this.tickers.add(() -> ticker.accept(comp));
        }
    }

    public void method_25393() {
        super.method_25393();
        this.tickers.forEach(Runnable::run);
    }

    public void debug(boolean enable) {
        if (this.uiAdapter != null) {
            this.uiAdapter.enableInspector = enable;
            this.uiAdapter.globalInspector = enable;
        }
    }
}

