/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.items.equipment;

import com.diamssword.greenresurgence.items.SimpleEnergyItemTiered;
import com.diamssword.greenresurgence.items.equipment.EquipmentTool;
import com.diamssword.greenresurgence.materials.BatteryTiers;
import com.diamssword.greenresurgence.systems.equipement.EffectLevel;
import com.diamssword.greenresurgence.systems.equipement.ElectricStackBasedEquipment;
import com.diamssword.greenresurgence.systems.equipement.IUpgradableEquipment;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EquipmentToolElectric
extends EquipmentTool
implements SimpleEnergyItemTiered {
    public static final RawAnimation POWERED_ANIM = RawAnimation.begin().thenLoop("powered");
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    private final boolean emissive;

    public EquipmentToolElectric(String category, String subCategory, boolean emissive) {
        super(category, subCategory);
        this.emissive = emissive;
    }

    @Override
    public boolean isEmissive() {
        return this.emissive;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            GeoItem.getOrAssignId((class_1799)stack, (class_3218)sw);
            if (stack.method_7969().method_10577("activated") && world.method_8510() % 80L == 0L) {
                long v = Math.max(this.getStoredEnergy(stack) - (long)BatteryTiers.BATTERY.recommendedDischargeRate() * 80L, 0L);
                this.setStoredEnergy(stack, v);
                if (v <= 0L) {
                    stack.method_7969().method_10556("activated", false);
                }
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5808 && user.method_6079().method_7909() instanceof SimpleEnergyItemTiered) {
            return class_1271.method_22430((Object)user.method_6047());
        }
        class_1799 st = user.method_5998(hand);
        if (this.getStoredEnergy(st) > 0L) {
            class_2487 comp;
            comp.method_10556("activated", !(comp = st.method_7948()).method_10577("activated"));
            st.method_7980(comp);
            user.method_7357().method_7906((class_1792)this, 20);
            return class_1271.method_22428((Object)st);
        }
        return class_1271.method_22431((Object)st);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return true;
    }

    @Override
    public Map<String, EffectLevel> getBaseUpgrades() {
        return new HashMap<String, EffectLevel>();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController cont = new AnimationController((GeoAnimatable)this, 1, state -> {
            class_1799 st = (class_1799)state.getData(DataTickets.ITEMSTACK);
            if (st != null && st.method_7948().method_10577("activated")) {
                state.getController().setAnimation(POWERED_ANIM);
            } else {
                state.getController().setAnimation(IDLE_ANIM);
            }
            return PlayState.CONTINUE;
        });
        cont.setParticleKeyframeHandler(event -> {});
        controllers.add(new AnimationController[]{cont});
    }

    @Override
    public IUpgradableEquipment getEquipment(class_1799 stack) {
        return new ElectricStackBasedEquipment(this.category, this.subCategory, stack);
    }

    @Override
    public ElectricStackBasedEquipment getEquipmentStack(class_1799 stack) {
        return (ElectricStackBasedEquipment)this.getEquipment(stack);
    }

    protected Optional<class_3545<SimpleEnergyItemTiered, class_1799>> getBattery(class_1799 stack) {
        return this.getEquipmentStack(stack).getBattery();
    }

    public long getEnergyCapacity(class_1799 stack) {
        return this.getBattery(stack).map(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).getEnergyCapacity((class_1799)pair.method_15441())).orElse(0L);
    }

    public long getEnergyMaxInput(class_1799 stack) {
        return this.getBattery(stack).map(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).getEnergyMaxInput((class_1799)pair.method_15441())).orElse(0L);
    }

    public long getEnergyMaxOutput(class_1799 stack) {
        return this.getBattery(stack).map(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).getEnergyMaxOutput((class_1799)pair.method_15441())).orElse(0L);
    }

    @Override
    public BatteryTiers getBatteryTier(class_1799 stack) {
        return this.getBattery(stack).map(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).getBatteryTier((class_1799)pair.method_15441())).orElse(BatteryTiers.BATTERY);
    }

    @Override
    public int method_31571(class_1799 stack) {
        return -11285270;
    }

    public long getStoredEnergy(class_1799 stack) {
        return this.getBattery(stack).map(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).getStoredEnergy((class_1799)pair.method_15441())).orElse(0L);
    }

    public void setStoredEnergy(class_1799 stack, long newAmount) {
        this.getBattery(stack).ifPresent(pair -> ((SimpleEnergyItemTiered)pair.method_15442()).setStoredEnergy((class_1799)pair.method_15441(), newAmount));
    }
}

