/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.items.equipment;

import com.diamssword.greenresurgence.MItems;
import com.diamssword.greenresurgence.systems.equipement.AdvEquipmentSlot;
import com.diamssword.greenresurgence.systems.equipement.EffectLevel;
import com.diamssword.greenresurgence.systems.equipement.EquipmentEffects;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentDef;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentEffect;
import com.diamssword.greenresurgence.systems.equipement.IEquipmentUpgrade;
import com.diamssword.greenresurgence.systems.equipement.TooltipHelper;
import com.diamssword.greenresurgence.systems.equipement.UpgradeActionContext;
import io.wispforest.owo.itemgroup.OwoItemSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class EquipmentUpgradeItem
extends class_1792
implements IEquipmentUpgrade {
    protected final String[] allowed;
    private final String slot;
    private final int durability;
    private final float weight;
    private List<String> effects = new ArrayList<String>();

    public EquipmentUpgradeItem(String allowed, String slot, float wheight) {
        this(new OwoItemSettings().maxCount(8).group(MItems.GROUP).tab(1), allowed, slot, -1, wheight, new String[0]);
    }

    public EquipmentUpgradeItem(String allowed, String slot, int durability, float wheight) {
        this(new OwoItemSettings().maxCount(8).group(MItems.GROUP).tab(1), allowed, slot, durability, wheight, new String[0]);
    }

    public EquipmentUpgradeItem(String allowed, String slot, int durability, float wheight, String ... effects) {
        this(new OwoItemSettings().maxCount(8).group(MItems.GROUP).tab(1), allowed, slot, durability, wheight, effects);
    }

    public EquipmentUpgradeItem(String allowed, String slot) {
        this(new OwoItemSettings().maxCount(8).group(MItems.GROUP).tab(1), allowed, slot, -1, 1.0f, new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        Map<String, EffectLevel> lvls = this.getEffectsLevels();
        UpgradeActionContext ctx = new UpgradeActionContext(null, null, UpgradeActionContext.ItemContext.UPGRADE).setLevels(lvls);
        tooltip.add((class_2561)class_2561.method_43471((String)"equipment.green_resurgence.upgrade.slot").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)("equipment.green_resurgence.gui." + this.slot)).method_27692(class_124.field_1076)));
        ArrayList<class_5250> tools = new ArrayList<class_5250>();
        for (String string : this.allowed) {
            String[] sp = string.split("/");
            if (sp[0].equals("*")) {
                tools.add(class_2561.method_43471((String)"item.green_resurgence.equipments.tool_any"));
                break;
            }
            if (sp.length > 1 && sp[1].equals("*")) {
                tools.add(class_2561.method_43471((String)("item.green_resurgence.equipments." + sp[0] + "_any")));
                continue;
            }
            if (sp.length <= 1) continue;
            tools.add(class_2561.method_43471((String)("item.green_resurgence.equipments." + sp[0] + "_" + sp[1])));
        }
        if (!tools.isEmpty()) {
            void var8_10;
            class_5250 class_52502 = class_2561.method_43473();
            for (int i = 0; i < tools.size(); ++i) {
                class_5250 class_52503 = var8_10.method_10852((class_2561)tools.get(i));
                if (i >= tools.size() - 1) continue;
                class_5250 class_52504 = class_52503.method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"equipment.green_resurgence.upgrade.applied.to").method_27692(class_124.field_1080).method_10852((class_2561)var8_10));
        }
        for (AdvEquipmentSlot advEquipmentSlot : AdvEquipmentSlot.values()) {
            ArrayList subList = new ArrayList();
            lvls.forEach((k, v) -> {
                Optional<IEquipmentEffect> eff = EquipmentEffects.get(k);
                eff.ifPresent(p -> p.addTooltips(ctx, advEquipmentSlot, subList));
            });
            if (subList.isEmpty()) continue;
            TooltipHelper.appendUpgradeHeader(advEquipmentSlot, ctx.context == UpgradeActionContext.ItemContext.UPGRADE, tooltip);
            tooltip.addAll(subList);
        }
        if (this.maxDurability() > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"equipment.green_resurgence.tooltip.max_durability", (Object[])new Object[]{this.maxDurability()}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"equipment.green_resurgence.tooltip.damage_weight", (Object[])new Object[]{Float.valueOf(this.damageWeight())}).method_27692(class_124.field_1080));
        }
    }

    public boolean method_7846() {
        return this.durability > -1;
    }

    public int maxDurability() {
        return this.durability;
    }

    public EquipmentUpgradeItem(OwoItemSettings settings, String allowed, String slot, int durability, float wheight, String ... effects) {
        super((class_1792.class_1793)settings);
        this.allowed = allowed.split(",");
        this.slot = slot;
        this.durability = durability;
        this.weight = wheight;
        this.effects = Arrays.asList(effects);
    }

    @Override
    public Map<String, EffectLevel> getEffectsLevels() {
        HashMap<String, EffectLevel> map = new HashMap<String, EffectLevel>();
        for (String effect : this.effects) {
            map.put(effect, new EffectLevel(1));
        }
        return map;
    }

    @Override
    public boolean canBeApplied(IEquipmentDef equipment, class_1799 stack) {
        for (String s : this.allowed) {
            String[] sp = s.split("/");
            if (!sp[0].equals("*") && !sp[0].equals(equipment.getEquipmentType()) || !sp[1].equals("*") && !sp[1].equals(equipment.getEquipmentSubtype())) continue;
            return true;
        }
        return false;
    }

    @Override
    public float damageWeight() {
        return this.weight;
    }

    @Override
    public String slot(IEquipmentDef equipment) {
        return this.slot;
    }

    public boolean method_31567(class_1799 stack) {
        return stack.method_7919() > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)stack.method_7919() * 13.0f / (float)this.durability);
    }

    public int method_31571(class_1799 stack) {
        float f = Math.max(0.0f, ((float)this.durability - (float)stack.method_7919()) / (float)this.durability);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

