/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.network;

import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.PlayerInventoryData;
import com.diamssword.greenresurgence.systems.crafting.CraftingProvider;
import com.diamssword.greenresurgence.systems.crafting.CraftingResult;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CraftPackets {
    private static int statusIndex = 0;
    private static Consumer<CraftingResult> currentTrackedClient;
    private static Map<class_3222, CraftStatusTracked> currentTrackedServer;

    public static void init() {
        Channels.MAIN.registerClientbound(SendCraftStatus.class, (msg, ctx) -> {
            if (msg.index == statusIndex && currentTrackedClient != null) {
                currentTrackedClient.accept(msg.recipe);
            }
        });
        Channels.MAIN.registerServerbound(RequestCraft.class, (msg, ctx) -> {
            CraftingProvider prov = new CraftingProvider().setForFaction((class_1657)ctx.player(), msg.pos);
            boolean r = prov.craftRecipe(msg.recipe, (class_1657)ctx.player());
            if (r && currentTrackedServer.containsKey(ctx.player())) {
                CraftStatusTracked p1 = currentTrackedServer.get(ctx.player());
                Channels.MAIN.serverHandle((class_1657)ctx.player()).send((Record)new SendCraftStatus(p1.index, prov.getRecipeStatus(msg.recipe, (class_1657)ctx.player())));
            }
        });
        Channels.MAIN.registerServerbound(RequestPlayerCraft.class, (msg, ctx) -> {
            PlayerInventoryData pli = (PlayerInventoryData)ctx.player().getComponent(Components.PLAYER_INVENTORY);
            pli.getCrafterProvider().craftRecipe(msg.recipe, (class_1657)ctx.player());
        });
        Channels.MAIN.registerServerbound(RequestCraftStatus.class, (msg, ctx) -> {
            CraftingProvider prov = new CraftingProvider().setForFaction((class_1657)ctx.player(), msg.pos);
            currentTrackedServer.put(ctx.player(), new CraftStatusTracked(msg.index, prov, msg.recipe));
            Channels.MAIN.serverHandle((class_1657)ctx.player()).send((Record)new SendCraftStatus(msg.index, prov.getRecipeStatus(msg.recipe, (class_1657)ctx.player())));
        });
        ServerTickEvents.START_SERVER_TICK.register(v -> {
            if (v.method_30002().method_8510() % 20L == 0L) {
                currentTrackedServer.forEach((k, va) -> Channels.MAIN.serverHandle((class_1657)k).send((Record)new SendCraftStatus(va.index, va.provider.getRecipeStatus(va.recipe, (class_1657)k))));
            }
        });
    }

    public static void sendCraftRequest(SimpleRecipe recipe, class_2338 pos) {
        Channels.MAIN.clientHandle().send((Record)new RequestCraft(pos, recipe));
    }

    public static void requestStatus(SimpleRecipe recipe, class_2338 pos, Consumer<CraftingResult> result) {
        currentTrackedClient = result;
        Channels.MAIN.clientHandle().send((Record)new RequestCraftStatus(++statusIndex, pos, recipe));
    }

    static {
        currentTrackedServer = new HashMap<class_3222, CraftStatusTracked>();
    }

    public record SendCraftStatus(Integer index, CraftingResult recipe) {
    }

    public record RequestCraft(class_2338 pos, SimpleRecipe recipe) {
    }

    public record RequestPlayerCraft(SimpleRecipe recipe) {
    }

    public record RequestCraftStatus(Integer index, class_2338 pos, SimpleRecipe recipe) {
    }

    private record CraftStatusTracked(Integer index, CraftingProvider provider, SimpleRecipe recipe) {
    }

    public record AllowedList(class_2960[] blocks, class_2960[] items) {
    }
}

