/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.network;

import com.diamssword.greenresurgence.items.IStructureProvider;
import com.diamssword.greenresurgence.network.Channels;
import com.diamssword.greenresurgence.structure.JigsawHelper;
import com.diamssword.greenresurgence.structure.StructureInfos;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class StructureSizePacket {
    public static void init() {
        Channels.MAIN.registerClientbound(StructureResponse.class, (msg, ctx) -> StructureInfos.setStructureInfos(msg));
        Channels.MAIN.registerServerbound(StructureRequest.class, (msg, ctx) -> {
            if (ctx.player().field_13974.method_14257() == class_1934.field_9220) {
                if (msg.type == IStructureProvider.StructureType.jigsaw) {
                    StructureResponse structureResponse = StructureSizePacket.loadJigSaw((class_3218)ctx.player().method_37908(), ctx.player().method_24515(), msg.dir, msg.name);
                    if (structureResponse != null) {
                        Channels.MAIN.serverHandle((class_1657)ctx.player()).send((Record)structureResponse);
                    }
                } else {
                    class_3485 structureManager = ((class_3218)ctx.player().method_37908()).method_14183();
                    Optional structure2 = structureManager.method_15094(msg.name);
                    if (structure2.isPresent()) {
                        class_3499 temp = (class_3499)structure2.get();
                        class_2338 p = class_2338.field_10980;
                        int[] off = StructureInfos.getOffsetSide(msg.dir, msg.type == IStructureProvider.StructureType.centered);
                        p = p.method_10069(off[0] * (temp.method_15160().method_10263() / 2), 0, off[1] * (temp.method_15160().method_10260() / 2));
                        Channels.MAIN.serverHandle((class_1657)ctx.player()).send((Record)new StructureResponse(msg.name, p, temp.method_15160(), msg.dir));
                    }
                }
            }
        });
    }

    public static StructureResponse loadJigSaw(class_3218 world, class_2338 pos, class_2350 dir, class_2960 structureName) {
        class_2338 blockPos = pos.method_10093(class_2350.field_11036);
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41249);
        class_5321 ent = class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)structureName);
        class_6880.class_6883 registryEntry = registry.method_40290(ent);
        class_2794 chunkGenerator = world.method_14178().method_12129();
        class_3485 structureTemplateManager = world.method_14183();
        class_5138 structureAccessor = world.method_27056();
        class_5819 random = world.method_8409();
        class_3195.class_7149 context = new class_3195.class_7149(world.method_30349(), chunkGenerator, chunkGenerator.method_12098(), world.method_14178().method_41248(), structureTemplateManager, world.method_8412(), new class_1923(pos), (class_5539)world, biome -> true);
        Optional<class_3195.class_7150> optional = JigsawHelper.generate(context, (class_6880<class_3785>)registryEntry, Optional.of(StructureInfos.PLACER_ENTRY), 7, blockPos, false, Optional.empty(), 128, StructureInfos.getRotation(dir));
        if (!optional.isPresent()) {
            optional = JigsawHelper.generate(context, (class_6880<class_3785>)registryEntry, Optional.empty(), 7, blockPos, true, Optional.empty(), 128, StructureInfos.getRotation(dir));
        }
        if (optional.isPresent()) {
            class_6626 structurePiecesCollector = optional.get().method_44019();
            for (class_3443 structurePiece : structurePiecesCollector.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                class_3341 box = poolStructurePiece.method_14935();
                Optional<class_3499.class_3501> start = poolStructurePiece.method_16644().method_16627(structureTemplateManager, pos, StructureInfos.getRotation(dir), random).stream().filter(i -> i.comp_1343().method_10558("name").equals(StructureInfos.PLACER_ENTRY.toString())).findFirst();
                class_2338 off = pos;
                if (start.isPresent()) {
                    off = start.get().comp_1341();
                }
                return new StructureResponse(structureName, off.method_10059((class_2382)pos), box.method_14659(), dir);
            }
        }
        return null;
    }

    public record StructureResponse(class_2960 name, class_2338 offset, class_2382 size, class_2350 dir) {
    }

    public record StructureRequest(class_2960 name, class_2350 dir, IStructureProvider.StructureType type) {
    }
}

