/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.render.images;

import com.diamssword.greenresurgence.GreenResurgence;
import com.diamssword.greenresurgence.render.images.ImageTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;

@Environment(value=EnvType.CLIENT)
public class TextureCache {
    private final Map<String, class_2960> clientResourceCache;
    private final Map<String, Long> waitingCache = new HashMap<String, Long>();
    private final Map<class_2960, class_3545<Integer, Integer>> ratioCache = new HashMap<class_2960, class_3545<Integer, Integer>>();
    public static TextureCache instance;

    public TextureCache() {
        this.clientResourceCache = new HashMap<String, class_2960>();
    }

    private void loadImageFromUrl(String url, Consumer<class_2960> callback) {
        this.waitingCache.put(url, System.currentTimeMillis());
        new Thread(() -> {
            try {
                this.addImage(url, ImageIO.read(new URL(url)), callback);
            }
            catch (IOException e) {
                GreenResurgence.LOGGER.error("Could not read image from url: " + url);
            }
        }).start();
    }

    public void addImage(String url, BufferedImage image, Consumer<class_2960> callback) {
        if (image == null) {
            GreenResurgence.LOGGER.error("Received null image from url: " + url);
            return;
        }
        class_2960 resourceLocation = GreenResurgence.asRessource("texures/images/" + String.valueOf(UUID.randomUUID()));
        ImageTextureObject cameraTextureObject = new ImageTextureObject(ImageTools.toNativeImage(image));
        this.ratioCache.put(resourceLocation, (class_3545<Integer, Integer>)new class_3545((Object)image.getWidth(), (Object)image.getHeight()));
        this.clientResourceCache.put(url, resourceLocation);
        class_310.method_1551().method_1561().field_4685.method_4616(resourceLocation, (class_1044)cameraTextureObject);
        this.waitingCache.remove(url);
        callback.accept(resourceLocation);
    }

    public void getImage(String url, Consumer<class_2960> callback) {
        class_2960 id = this.clientResourceCache.get(url);
        if (id == null && url != null && url.length() > 1) {
            if (this.waitingCache.containsKey(url)) {
                if (this.waitingCache.get(url) + 10000L < System.currentTimeMillis()) {
                    this.waitingCache.remove(url);
                }
            } else {
                this.loadImageFromUrl(url, callback);
            }
        } else {
            callback.accept(id);
        }
    }

    public class_2960 getImage(String url) {
        class_2960 id = this.clientResourceCache.get(url);
        if (id == null && url != null && url.length() > 1) {
            if (this.waitingCache.containsKey(url)) {
                if (this.waitingCache.get(url) + 10000L < System.currentTimeMillis()) {
                    this.waitingCache.remove(url);
                }
            } else {
                this.loadImageFromUrl(url, v -> {});
            }
        }
        return id;
    }

    public class_3545<Integer, Integer> getSize(class_2960 id) {
        return this.ratioCache.get(id);
    }

    public static TextureCache instance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    @Environment(value=EnvType.CLIENT)
    public class ImageTextureObject
    extends class_1043 {
        public ImageTextureObject(class_1011 image) {
            super(image);
        }
    }
}

