/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.character;

import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.character.HealthManager;
import com.diamssword.greenresurgence.systems.character.PosesManager;
import com.diamssword.greenresurgence.systems.character.customPoses.IPlayerCustomPose;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_4050;

public class PlayerData
implements ComponentV3,
ServerTickingComponent,
ClientTickingComponent,
AutoSyncedComponent {
    public static int SYNC_MODE_FULL = 0;
    public static int SYNC_MODE_HUD = 1;
    public static int SYNC_MODE_CLOTH = 2;
    private class_4050 forcedPose;
    private String customPoseID;
    private IPlayerCustomPose customPose;
    public final class_1657 player;
    private class_2487 carriedEntity;
    public final HealthManager healthManager;

    public PlayerData(class_1657 e) {
        this.player = e;
        this.healthManager = new HealthManager(e);
    }

    public boolean isForcedPose() {
        return this.forcedPose != null && this.forcedPose != class_4050.field_18076;
    }

    public class_4050 getPose() {
        return this.forcedPose;
    }

    public void setForcedPose(class_4050 pose) {
        this.forcedPose = pose;
        this.player.method_18380(pose);
        PlayerData.syncApparence(this.player);
    }

    public void placeCarriedEntity() {
        if (this.carriedEntity != null) {
            this.getCarriedEntity().ifPresent(et -> this.player.method_37908().method_8649(et));
            this.carriedEntity = null;
        }
    }

    public boolean isCarryingEntity() {
        return this.carriedEntity != null;
    }

    public Optional<class_1297> getCarriedEntity() {
        if (this.carriedEntity != null) {
            return class_1299.method_5892((class_2487)this.carriedEntity, (class_1937)this.player.method_37908()).map(e -> {
                e.method_30634(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
                return e;
            });
        }
        return Optional.empty();
    }

    public void setCarriedEntity(class_1297 e) {
        this.placeCarriedEntity();
        class_2487 tag = new class_2487();
        e.method_5786(tag);
        this.carriedEntity = tag;
        e.method_5650(class_1297.class_5529.field_26999);
        PlayerData.syncApparence(this.player);
    }

    public IPlayerCustomPose getCustomPose() {
        return this.customPose;
    }

    public String getCustomPoseID() {
        return this.customPoseID;
    }

    public void setCustomPose(String id) {
        if (id != null) {
            this.customPose = PosesManager.createPose(id, this.player);
            this.customPoseID = this.customPose != null ? id : null;
        } else {
            this.customPoseID = null;
            this.customPose = null;
        }
        this.player.method_18382();
        PlayerData.syncApparence(this.player);
    }

    public void serverTick() {
        if (this.customPose != null) {
            if (this.customPose.shouldExitPose(this.player)) {
                this.setCustomPose(null);
            } else {
                this.customPose.tick(this.player);
            }
        }
        this.healthManager.update();
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10545("health")) {
            this.healthManager.readNbt(tag.method_10562("health"));
        }
        if (tag.method_10545("pose")) {
            this.forcedPose = class_4050.valueOf((String)tag.method_10558("pose"));
        }
        if (tag.method_10545("carriedEntity")) {
            this.carriedEntity = tag.method_10562("carriedEntity");
        }
        if (tag.method_10545("customPoseID")) {
            String d = tag.method_10558("customPoseID");
            if (d.equals("null")) {
                this.customPose = null;
                this.customPoseID = null;
                this.player.method_18382();
            } else if (!d.equals(this.customPoseID) || this.customPose == null) {
                this.customPose = PosesManager.createPose(d, this.player);
                this.player.method_18382();
            }
            this.customPoseID = d;
        }
        if (tag.method_10545("shieldAmount")) {
            this.healthManager.setShieldAmount(tag.method_10574("shieldAmount"));
        }
        if (tag.method_10545("energyAmount")) {
            this.healthManager.setEnergyAmount(tag.method_10574("energyAmount"));
        }
    }

    public void writeSyncPacket(class_2540 buf, class_3222 player) {
        this.writeSyncPacket(buf, player, SYNC_MODE_FULL);
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient, int mode) {
        class_2487 tag = new class_2487();
        if (mode == SYNC_MODE_FULL || mode == SYNC_MODE_CLOTH) {
            if (this.forcedPose != null) {
                tag.method_10582("pose", this.forcedPose.toString());
            }
            if (this.carriedEntity != null) {
                tag.method_10566("carriedEntity", (class_2520)this.carriedEntity);
            }
            if (this.customPoseID != null) {
                tag.method_10582("customPoseID", this.customPoseID);
            } else {
                tag.method_10582("customPoseID", "null");
            }
        }
        if (mode == SYNC_MODE_FULL || mode == SYNC_MODE_HUD) {
            tag.method_10549("shieldAmount", this.healthManager.getShieldAmount());
            tag.method_10549("energyAmount", this.healthManager.getEnergyAmount());
        }
        buf.method_10794(tag);
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            this.readFromNbt(tag);
        }
    }

    public void writeToNbt(class_2487 tag) {
        if (this.forcedPose != null) {
            tag.method_10582("pose", this.forcedPose.toString());
        }
        if (this.customPoseID != null) {
            tag.method_10582("customPoseID", this.customPoseID);
        }
        if (this.carriedEntity != null) {
            tag.method_10566("carriedEntity", (class_2520)this.carriedEntity);
        }
        class_2487 t1 = new class_2487();
        this.healthManager.writeNbt(t1);
        tag.method_10566("health", (class_2520)t1);
    }

    public void clientTick() {
        if (this.customPose != null) {
            this.customPose.tick(this.player);
        }
        this.healthManager.update();
    }

    public static void syncFull(class_1657 player) {
        PlayerData dt = (PlayerData)player.getComponent(Components.PLAYER_DATA);
        Components.PLAYER_DATA.sync((Object)player, (b, p) -> dt.writeSyncPacket(b, p, SYNC_MODE_FULL), p -> p == dt.player);
    }

    public static void syncHUD(class_1657 player) {
        PlayerData dt = (PlayerData)player.getComponent(Components.PLAYER_DATA);
        Components.PLAYER_DATA.sync((Object)player, (b, p) -> dt.writeSyncPacket(b, p, SYNC_MODE_HUD), p -> p == dt.player);
    }

    public static void syncApparence(class_1657 player) {
        PlayerData dt = (PlayerData)player.getComponent(Components.PLAYER_DATA);
        Components.PLAYER_DATA.sync((Object)player, (b, p) -> dt.writeSyncPacket(b, p, SYNC_MODE_CLOTH));
    }
}

