/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.character;

import com.diamssword.greenresurgence.containers.player.CustomPlayerInventory;
import com.diamssword.greenresurgence.systems.Components;
import com.diamssword.greenresurgence.systems.crafting.PendingCraft;
import com.diamssword.greenresurgence.systems.crafting.Recipes;
import com.diamssword.greenresurgence.systems.crafting.SimpleRecipe;
import com.diamssword.greenresurgence.systems.crafting.TimedCraftingProvider;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ClientTickingComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Contract;

public class PlayerInventoryData
implements ComponentV3,
ServerTickingComponent,
ClientTickingComponent,
AutoSyncedComponent {
    private TimedCraftingProvider crafterProvider = new TimedCraftingProvider();
    private final CustomPlayerInventory inventory = new CustomPlayerInventory();
    public final class_1657 player;
    private class_1799 backpackStack = class_1799.field_8037;

    public PlayerInventoryData(class_1657 e) {
        this.player = e;
        this.inventory.fromNBT(new class_2487(), this.player);
        if (!e.method_37908().field_9236) {
            this.crafterProvider.onNewRecipeQueued(() -> this.player.syncComponent(Components.PLAYER_INVENTORY));
        }
    }

    public boolean shouldSyncWith(class_3222 player) {
        return true;
    }

    public TimedCraftingProvider getCrafterProvider() {
        this.crafterProvider.setForPlayer(this.getInventory());
        return this.crafterProvider;
    }

    public CustomPlayerInventory getInventory() {
        return this.inventory;
    }

    public class_1799 getBackpackStack() {
        return this.backpackStack;
    }

    public void setBackpackStack(class_1799 stack) {
        this.backpackStack = stack;
    }

    public void clientTick() {
        this.crafterProvider.tickClient(this.player);
        this.inventory.updateItems();
    }

    public void serverTick() {
        this.crafterProvider.tick(this.player);
        this.inventory.updateItems();
        class_1799 bak1 = this.inventory.getBags().method_5438(0);
        if (bak1.method_7909() != this.backpackStack.method_7909()) {
            this.backpackStack = bak1.method_7972();
            this.player.syncComponent(Components.PLAYER_INVENTORY);
        }
        if (this.inventory.InventoryScreenNeedRefresh) {
            CustomPlayerInventory.openInventoryScreen(this.player);
            this.inventory.InventoryScreenNeedRefresh = false;
        }
    }

    @Contract(mutates="param1")
    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        class_2487 tag = new class_2487();
        if (recipient == this.player) {
            class_2499 pendingCrafts = new class_2499();
            this.crafterProvider.getPendingCrafts().forEach(c -> pendingCrafts.add((Object)class_2519.method_23256((String)c.recipe.getId().toString())));
            tag.method_10566("pendingcrafts", (class_2520)pendingCrafts);
        }
        tag.method_10566("backpack", (class_2520)this.backpackStack.method_7953(new class_2487()));
        buf.method_10794(tag);
    }

    public void applySyncPacket(class_2540 buf) {
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            if (tag.method_10545("pendingcrafts")) {
                class_2499 ls = tag.method_10554("pendingcrafts", 8);
                this.crafterProvider.clearPendings();
                ls.forEach(l1 -> {
                    Optional<SimpleRecipe> r = Recipes.getRecipe(new class_2960(l1.method_10714()));
                    r.ifPresent(recipe -> this.crafterProvider.addPending(new PendingCraft((SimpleRecipe)recipe)));
                });
            }
            if (tag.method_10545("backpack")) {
                this.backpackStack = class_1799.method_7915((class_2487)tag.method_10562("backpack"));
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.inventory.fromNBT(tag, this.player);
        if (tag.method_10545("crafter")) {
            this.crafterProvider = new TimedCraftingProvider(tag.method_10562("crafter"));
            if (!this.player.method_37908().field_9236) {
                this.crafterProvider.onNewRecipeQueued(() -> this.player.syncComponent(Components.PLAYER_INVENTORY));
            }
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10566("crafter", (class_2520)this.crafterProvider.toNBT());
        this.inventory.toNBT(tag);
    }
}

