/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.greenresurgence.systems.equipement;

import net.minecraft.class_1304;
import org.jetbrains.annotations.Nullable;

public enum AdvEquipmentSlot {
    MAINHAND(Type.HAND, class_1304.field_6173),
    OFFHAND(Type.HAND, class_1304.field_6171),
    FEET(Type.ARMOR, class_1304.field_6166),
    LEGS(Type.ARMOR, class_1304.field_6172),
    CHEST(Type.ARMOR, class_1304.field_6174),
    HEAD(Type.ARMOR, class_1304.field_6169),
    BACKPACK(Type.BACKPACK, 0, "backpack"),
    SATCHEL_LEFT(Type.SATCHEL, 0, "satchel_left"),
    SATCHEL_RIGHT(Type.SATCHEL, 1, "satchel_right"),
    UNKNOWN(Type.UNKNOWN, 1, "unknown");

    private final Type type;
    private final class_1304 parent;
    private final int entityId;
    private final String name;

    private AdvEquipmentSlot(Type type, int entityId, String name) {
        this.type = type;
        this.entityId = entityId;
        this.name = name;
        this.parent = null;
    }

    private AdvEquipmentSlot(Type type, class_1304 parent) {
        this.type = type;
        this.entityId = parent.method_5927();
        this.name = parent.method_5923();
        this.parent = parent;
    }

    @Nullable
    public class_1304 getParent() {
        return this.parent;
    }

    public Type getType() {
        return this.type;
    }

    public int getEntitySlotId() {
        return this.entityId;
    }

    public int getOffsetEntitySlotId(int offset) {
        return offset + this.entityId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmorSlot() {
        return this.type == Type.ARMOR;
    }

    public static AdvEquipmentSlot byName(String name) {
        for (AdvEquipmentSlot equipmentSlot : AdvEquipmentSlot.values()) {
            if (!equipmentSlot.getName().equals(name)) continue;
            return equipmentSlot;
        }
        throw new IllegalArgumentException("Invalid slot '" + name + "'");
    }

    public static AdvEquipmentSlot fromVanilla(class_1304 slot) {
        for (AdvEquipmentSlot equipmentSlot : AdvEquipmentSlot.values()) {
            if (equipmentSlot.getParent() != slot) continue;
            return equipmentSlot;
        }
        return null;
    }

    public static AdvEquipmentSlot fromTypeIndex(Type type, int index) {
        for (AdvEquipmentSlot equipmentSlot : AdvEquipmentSlot.values()) {
            if (equipmentSlot.getType() != type || equipmentSlot.getEntitySlotId() != index) continue;
            return equipmentSlot;
        }
        throw new IllegalArgumentException("Invalid slot '" + String.valueOf((Object)type) + "': " + index);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BACKPACK,
        SATCHEL,
        UNKNOWN;

    }
}

